# ValueSet - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check - Regular Medications**](Questionnaire-RegularMedications.md)
* **ValueSet**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/RegularMedications#MedicationStatementStatusLimited | *Version*:0.3.0 |
| Draft | *Computable Name*:MedicationStatementStatusLimited |

 
This value set includes the minimal set of codes to represent the status of a medication statement (i.e., active, completed, stopped and on-hold). 

 **References** 

* [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://hl7.org/fhir/CodeSystem/medication-statement-status`](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)

 

### Expansion

Expansion based on [codesystem Medication status codes v4.0.1 (CodeSystem)](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

