# ValueSet - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check**](Questionnaire-AssemblyInstructions.md)
* **ValueSet**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715#condition-clinical | *Version*:0.3.0 |
| Draft as of 2019-11-01 | *Computable Name*:ConditionClinicalStatusCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.3.164 | |
| **Copyright/Legal**: Copyright © 2011+ HL7. Licensed under Creative Commons "No Rights Reserved". | |

 
Preferred value set for Condition Clinical Status. 

 **References** 

* [Condition](http://hl7.org/fhir/R4/condition.html)
* [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)

### Logical Definition (CLD)

* Include all codes defined in [`http://terminology.hl7.org/CodeSystem/condition-clinical`](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html)

 

### Expansion

Expansion based on [codesystem Condition Clinical Status Codes v3.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html)

This value set contains 7 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

