# Allergy Intolerance Clinical Status Minimal - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Allergy Intolerance Clinical Status Minimal**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-AllergyIntoleranceClinicalStatusMinimal.xml.md) 
*  [JSON](ValueSet-AllergyIntoleranceClinicalStatusMinimal.json.md) 
*  [TTL](ValueSet-AllergyIntoleranceClinicalStatusMinimal.ttl.md) 

## ValueSet: Allergy Intolerance Clinical Status Minimal 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ValueSet/AllergyIntoleranceClinicalStatusMinimal | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:AllergyIntoleranceClinicalStatusMinimal |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This value set includes the minimal set of codes to represent the clinical status of an allergy intolerance (i.e., active and inactive). 

 **References** 

* [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical`](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html)

 

### Expansion

Expansion based on [codesystem AllergyIntolerance Clinical Status Codes v1.0.0 (CodeSystem)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-clinical.html)

This value set contains 2 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

