# AU Core Head Circumference - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AU Core Head Circumference**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-au-core-headcircum-definitions.md) 
*  [Mappings](StructureDefinition-au-core-headcircum-mappings.md) 
*  [XML](StructureDefinition-au-core-headcircum.profile.xml.md) 
*  [JSON](StructureDefinition-au-core-headcircum.profile.json.md) 
*  [TTL](StructureDefinition-au-core-headcircum.profile.ttl.md) 

## Resource Profile: AU Core Head Circumference 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-headcircum | *Version*:0.2.2-preview | | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[HL7 Australia](https://confluence.hl7.org/display/HAFWG) | *Computable Name*:AUCoreHeadCircumference |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.This resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. The rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material. No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted.This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2021, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.All copies of this resource must include this copyright statement and all information contained in this statement. | | | |

 
This profile sets minimum expectations for an Observation resource to record, search, and fetch head circumference observations with standard coding and units of measure. It is based on the[FHIR Head Circumference Profile](http://hl7.org/fhir/R4/headcircum.html)and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets that**SHALL**be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

**Usages:**

* Derived from this Profile: [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/au-core-headcircum)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [observation-headcircum](http://hl7.org/fhir/R4/headcircum.html) 

#### Terminology Bindings (Differential)

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [observation-headcircum](http://hl7.org/fhir/R4/headcircum.html) 

**Summary**

Mandatory: 0 element(3 nested mandatory elements)
 Must-Support: 3 elements
 Fixed: 3 elements

**Structures**

This structure refers to these other structures:

* [AU Core Patient(http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-patient.html)
* [AU Core Encounter(http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-encounter.html)
* [AU Core Practitioner(http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitioner.html)
* [AU Core PractitionerRole(http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitionerrole.html)
* [AU Core Organization(http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-organization.html)
* [AU Core RelatedPerson(http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-relatedperson.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [observation-headcircum](http://hl7.org/fhir/R4/headcircum.html) 

#### Terminology Bindings (Differential)

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [observation-headcircum](http://hl7.org/fhir/R4/headcircum.html) 

**Summary**

Mandatory: 0 element(3 nested mandatory elements)
 Must-Support: 3 elements
 Fixed: 3 elements

**Structures**

This structure refers to these other structures:

* [AU Core Patient(http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-patient.html)
* [AU Core Encounter(http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-encounter.html)
* [AU Core Practitioner(http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitioner.html)
* [AU Core PractitionerRole(http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitionerrole.html)
* [AU Core Organization(http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-organization.html)
* [AU Core RelatedPerson(http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson)](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-relatedperson.html)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 0

 

Other representations of profile: [CSV](StructureDefinition-au-core-headcircum.csv), [Excel](StructureDefinition-au-core-headcircum.xlsx), [Schematron](StructureDefinition-au-core-headcircum.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

