# Template Extract Extension Patch Request URL - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Template Extract Extension Patch Request URL**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-TemplateExtractExtensionPatchRequestUrl-definitions.md) 
*  [Mappings](StructureDefinition-TemplateExtractExtensionPatchRequestUrl-mappings.md) 
*  [XML](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.profile.xml.md) 
*  [JSON](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.profile.json.md) 
*  [TTL](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.profile.ttl.md) 

## Extension: Template Extract Extension Patch Request URL 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:TemplateExtractExtensionPatchRequestUrl |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the [Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html) extension.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AllergiesAdverseReactions](Questionnaire-AllergiesAdverseReactions.md), [MedicalHistoryCurrentProblems](Questionnaire-MedicalHistoryCurrentProblems.md) and [RegularMedications](Questionnaire-RegularMedications.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/TemplateExtractExtensionPatchRequestUrl)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type string: This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the [Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html) extension.

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type string: This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the [Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html) extension.

 

Other representations of profile: [CSV](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.csv), [Excel](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.xlsx), [Schematron](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.sch) 

#### Constraints

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

