# Smart Health Checks Practitioner - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Practitioner**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCPractitioner-definitions.md) 
*  [Mappings](StructureDefinition-SHCPractitioner-mappings.md) 
*  [Examples](StructureDefinition-SHCPractitioner-examples.md) 
*  [XML](StructureDefinition-SHCPractitioner.profile.xml.md) 
*  [JSON](StructureDefinition-SHCPractitioner.profile.json.md) 
*  [TTL](StructureDefinition-SHCPractitioner.profile.ttl.md) 

## Resource Profile: Smart Health Checks Practitioner 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCPractitioner | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksPractitioner |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for a Practitioner resource to search and retrieve practitioner information when used within Smart Health Checks. 

**Usages:**

* Examples for this Profile: [Practitioner/primary-peter](Practitioner-primary-peter.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCPractitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCorePractitioner](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitioner.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCorePractitioner](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitioner.html) 

**Summary**

Must-Support: 1 element

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [AUCorePractitioner](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitioner.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCorePractitioner](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-practitioner.html) 

**Summary**

Must-Support: 1 element

 

Other representations of profile: [CSV](StructureDefinition-SHCPractitioner.csv), [Excel](StructureDefinition-SHCPractitioner.xlsx), [Schematron](StructureDefinition-SHCPractitioner.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

