# Smart Health Checks Patient - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patient**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCPatient-definitions.md) 
*  [Mappings](StructureDefinition-SHCPatient-mappings.md) 
*  [Examples](StructureDefinition-SHCPatient-examples.md) 
*  [XML](StructureDefinition-SHCPatient.profile.xml.md) 
*  [JSON](StructureDefinition-SHCPatient.profile.json.md) 
*  [TTL](StructureDefinition-SHCPatient.profile.ttl.md) 

## Resource Profile: Smart Health Checks Patient 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCPatient | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksPatient |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for a Patient resource to search and retrieve patient information when used within Smart Health Checks. 

**Usages:**

* Examples for this Profile: [Patient/pat-sf](Patient-pat-sf.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCPatient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCorePatient](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-patient.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCorePatient](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-patient.html) 

**Summary**

Must-Support: 18 elements

**Structures**

This structure refers to these other structures:

* [AU Pensioner Concession Card Number(http://hl7.org.au/fhir/StructureDefinition/au-pensionerconcessioncardnumber)](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-pensionerconcessioncardnumber.html)
* [AU Health Care Card Number(http://hl7.org.au/fhir/StructureDefinition/au-healthcarecardnumber)](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-healthcarecardnumber.html)
* [Australian Address(http://hl7.org.au/fhir/StructureDefinition/au-address)](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-address.html)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [AUCorePatient](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-patient.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCorePatient](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-patient.html) 

**Summary**

Must-Support: 18 elements

**Structures**

This structure refers to these other structures:

* [AU Pensioner Concession Card Number(http://hl7.org.au/fhir/StructureDefinition/au-pensionerconcessioncardnumber)](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-pensionerconcessioncardnumber.html)
* [AU Health Care Card Number(http://hl7.org.au/fhir/StructureDefinition/au-healthcarecardnumber)](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-healthcarecardnumber.html)
* [Australian Address(http://hl7.org.au/fhir/StructureDefinition/au-address)](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-address.html)

 

Other representations of profile: [CSV](StructureDefinition-SHCPatient.csv), [Excel](StructureDefinition-SHCPatient.xlsx), [Schematron](StructureDefinition-SHCPatient.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

