# Smart Health Checks Patch MedicationStatement - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch MedicationStatement**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCPatchMedicationStatement-definitions.md) 
*  [Mappings](StructureDefinition-SHCPatchMedicationStatement-mappings.md) 
*  [Examples](StructureDefinition-SHCPatchMedicationStatement-examples.md) 
*  [XML](StructureDefinition-SHCPatchMedicationStatement.profile.xml.md) 
*  [JSON](StructureDefinition-SHCPatchMedicationStatement.profile.json.md) 
*  [TTL](StructureDefinition-SHCPatchMedicationStatement.profile.ttl.md) 

## Resource Profile: Smart Health Checks Patch MedicationStatement 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksPatchMedicationStatement |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the expectations for a Parameters resource when used to patch MedicationStatement resources within Smart Health Checks. 

### Usage Scenarios

This profile supports updating MedicationStatement resource elements that are applicable to Smart Health Checks using the FHIRPath patch method. FHIRPath patch uses the Parameters resource to describe how a patch operation should be performed.

The elements that can be updated using this profile are as follows:

* Profile: [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)
  * Element path: * `MedicationStatement.status`
* `MedicationStatement.dosage[0].text`
* `MedicationStatement.note[0].text`


### Profile Specific Implementation Guidance

* `Parameters.parameter.part:path.value[x]:valueString` **SHALL** identify one of the relevant MedicationStatement element paths included in the [Smart Health Checks Patch MedicationStatement Element Path value set](ValueSet-SHCPatchMedicationStatementElementPath.md): `MedicationStatement`, `MedicationStatement.dosage[0]`, or `MedicationStatement.note[0]`.
* `Parameters.parameter.part:name.value[x]:valueString` **SHALL** identify one of the relevant MedicationStatement element paths included in the [Smart Health Checks Patch MedicationStatement Element Name value set](ValueSet-SHCPatchMedicationStatementElementName.md): `status`, `text`, `dosage` or `note`.
* When the path value is `MedicationStatement` and the name value is `status`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `code`
* `Parameters.parameter.part:value.value[x]:valueCode` **SHALL** have a value from the [Medication Statement Status Limited value set](ValueSet-MedicationStatementStatusLimited.md).
 
* When the path value is `MedicationStatement` and the name value is `dosage`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `Dosage`.
 
* When the path value is `MedicationStatement.dosage[0]` and the name value is `text`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `string`.
 
* When the path value is `MedicationStatement` and the name value is `note`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `Annotation`.
 
* When the path value is `MedicationStatement.note[0]` and the name value is `text`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `markdown`.
 

Illustrative examples are provided.

`Parameters.parameter.part:value.value[x]` has **Must Support** obligations on each of the allowed data types. Due to a validation issue, it is not currently possible to have slices defined for both `valueCode` and `valueString`. For this reason, `valueString` is not currently defined as a slice and does not have **Must Support** obligations included in the StructureDefinition.

`valueString` is to be considered a **Must Support** data type with the same obligations as the other allowed data types (as below).

| | |
| :--- | :--- |
| `SHALL:process` | SHC Host FHIR Server |
| `SHALL:populate-if-known` | SHC App |

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* Examples for this Profile: [Parameters/SHCPatchMedicationStatement1](Parameters-SHCPatchMedicationStatement1.md), [Parameters/SHCPatchMedicationStatement2](Parameters-SHCPatchMedicationStatement2.md), [Parameters/SHCPatchMedicationStatement3](Parameters-SHCPatchMedicationStatement3.md) and [Parameters/SHCPatchMedicationStatement4](Parameters-SHCPatchMedicationStatement4.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCPatchMedicationStatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

#### Terminology Bindings (Differential)

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

**Summary**

Mandatory: 9 elements(2 nested mandatory elements)
 Must-Support: 22 elements
 Fixed: 7 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Parameters.parameter.part
* The element 1 is sliced based on the value of Parameters.parameter.part.value[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

#### Terminology Bindings (Differential)

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

**Summary**

Mandatory: 9 elements(2 nested mandatory elements)
 Must-Support: 22 elements
 Fixed: 7 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Parameters.parameter.part
* The element 1 is sliced based on the value of Parameters.parameter.part.value[x]

 

Other representations of profile: [CSV](StructureDefinition-SHCPatchMedicationStatement.csv), [Excel](StructureDefinition-SHCPatchMedicationStatement.xlsx), [Schematron](StructureDefinition-SHCPatchMedicationStatement.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

