# Smart Health Checks Patch Condition - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch Condition**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCPatchCondition-definitions.md) 
*  [Mappings](StructureDefinition-SHCPatchCondition-mappings.md) 
*  [Examples](StructureDefinition-SHCPatchCondition-examples.md) 
*  [XML](StructureDefinition-SHCPatchCondition.profile.xml.md) 
*  [JSON](StructureDefinition-SHCPatchCondition.profile.json.md) 
*  [TTL](StructureDefinition-SHCPatchCondition.profile.ttl.md) 

## Resource Profile: Smart Health Checks Patch Condition 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksPatchCondition |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the expectations for a Parameters resource when used to patch Condition resources within Smart Health Checks. 

### Usage Scenarios

This profile supports updating Condition resource elements that are applicable to Smart Health Checks using the FHIRPath patch method. FHIRPath patch uses the Parameters resource to describe how a patch operation should be performed.

The elements that can be updated using this profile are as follows:

* Profile: [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)
  * Element path: * `Condition.clinicalStatus`
* `Condition.abatement`


### Profile Specific Implementation Guidance

* `Parameters.parameter.part:path.value[x]:valueString` **SHALL** identify one of the relevant Condition element paths included in the [Smart Health Checks Patch Condition Element Path value set](ValueSet-SHCPatchConditionElementPath.md): `Condition`.
* `Parameters.parameter.part:name.value[x]:valueString` **SHALL** identify one of the relevant Condition element paths included in the [Smart Health Checks Patch Condition Element Name value set](ValueSet-SHCPatchConditionElementName.md): `clinicalStatus` or `abatement`.
* When the path value is `Condition` and the name value is `clinicalStatus`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `CodeableConcept`
* `Parameters.parameter.part:value.value[x]:valueCodeableConcept` **SHALL** have a value from the [Condition Clinical Status Codes value set](http://hl7.org/fhir/R4/valueset-condition-clinical.html).
 
* When the path value is `Condition` and the name value is `abatement`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `dateTime`.
 

Illustrative examples are provided.

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* Examples for this Profile: [Parameters/SHCPatchCondition1](Parameters-SHCPatchCondition1.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCPatchCondition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

#### Terminology Bindings (Differential)

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

**Summary**

Mandatory: 9 elements(1 nested mandatory element)
 Must-Support: 18 elements
 Fixed: 7 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Parameters.parameter.part
* The element 1 is sliced based on the value of Parameters.parameter.part.value[x]

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

#### Terminology Bindings (Differential)

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Parameters](http://hl7.org/fhir/R4/parameters.html) 

**Summary**

Mandatory: 9 elements(1 nested mandatory element)
 Must-Support: 18 elements
 Fixed: 7 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Parameters.parameter.part
* The element 1 is sliced based on the value of Parameters.parameter.part.value[x]

 

Other representations of profile: [CSV](StructureDefinition-SHCPatchCondition.csv), [Excel](StructureDefinition-SHCPatchCondition.xlsx), [Schematron](StructureDefinition-SHCPatchCondition.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

