# Smart Health Checks Head Circumference - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Head Circumference**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCHeadCircumference-definitions.md) 
*  [Mappings](StructureDefinition-SHCHeadCircumference-mappings.md) 
*  [XML](StructureDefinition-SHCHeadCircumference.profile.xml.md) 
*  [JSON](StructureDefinition-SHCHeadCircumference.profile.json.md) 
*  [TTL](StructureDefinition-SHCHeadCircumference.profile.ttl.md) 

## Resource Profile: Smart Health Checks Head Circumference 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCHeadCircumference | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksHeadCircumference |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for a Head Circumference resource to record, search and save head circumference information when used within Smart Health Checks. 

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCHeadCircumference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCoreHeadCircumference](StructureDefinition-au-core-headcircum.md) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCoreHeadCircumference](StructureDefinition-au-core-headcircum.md) 

**Summary**

Must-Support: 3 elements

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [AUCoreHeadCircumference](StructureDefinition-au-core-headcircum.md) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCoreHeadCircumference](StructureDefinition-au-core-headcircum.md) 

**Summary**

Must-Support: 3 elements

 

Other representations of profile: [CSV](StructureDefinition-SHCHeadCircumference.csv), [Excel](StructureDefinition-SHCHeadCircumference.xlsx), [Schematron](StructureDefinition-SHCHeadCircumference.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

