# Smart Health Checks Extract Bundle - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Extract Bundle**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCExtractBundle-definitions.md) 
*  [Mappings](StructureDefinition-SHCExtractBundle-mappings.md) 
*  [Examples](StructureDefinition-SHCExtractBundle-examples.md) 
*  [XML](StructureDefinition-SHCExtractBundle.profile.xml.md) 
*  [JSON](StructureDefinition-SHCExtractBundle.profile.json.md) 
*  [TTL](StructureDefinition-SHCExtractBundle.profile.ttl.md) 

## Resource Profile: Smart Health Checks Extract Bundle 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCExtractBundle | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksExtractBundle |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the expectations for a Bundle resource when used to represent a transaction bundle of resources extracted by the SHC App following the completion of a Smart Health Checks Questionnaire. This bundle is used to write patient information to the SHC Host FHIR server. 

**Usages:**

* Examples for this Profile: [Bundle/sdc-template-extract-928bbdd27d15](Bundle-sdc-template-extract-928bbdd27d15.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCExtractBundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 2 elements(6 nested mandatory elements)
 Must-Support: 14 elements
 Fixed: 3 elements

**Structures**

This structure refers to these other structures:

* [Smart Health Checks AllergyIntolerance(https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance)](StructureDefinition-SHCAllergyIntolerance.md)
* [Smart Health Checks Condition(https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition)](StructureDefinition-SHCCondition.md)
* [Smart Health Checks Immunization(https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization)](StructureDefinition-SHCImmunization.md)
* [Smart Health Checks MedicationStatement(https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement)](StructureDefinition-SHCMedicationStatement.md)
* [Smart Health Checks Blood Pressure(https://smartforms.csiro.au/ig/StructureDefinition/SHCBloodPressure)](StructureDefinition-SHCBloodPressure.md)
* [Smart Health Checks Body Height(https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyHeight)](StructureDefinition-SHCBodyHeight.md)
* [Smart Health Checks Body Weight(https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight)](StructureDefinition-SHCBodyWeight.md)
* [Smart Health Checks Heart Rate(https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRate)](StructureDefinition-SHCHeartRate.md)
* [Smart Health Checks Heart Rhythm(https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRhythm)](StructureDefinition-SHCHeartRhythm.md)
* [Smart Health Checks Smoking Status(https://smartforms.csiro.au/ig/StructureDefinition/SHCSmokingStatus)](StructureDefinition-SHCSmokingStatus.md)
* [Smart Health Checks Waist Circumference(https://smartforms.csiro.au/ig/StructureDefinition/SHCWaistCircumference)](StructureDefinition-SHCWaistCircumference.md)
* [Smart Health Checks Head Circumference(https://smartforms.csiro.au/ig/StructureDefinition/SHCHeadCircumference)](StructureDefinition-SHCHeadCircumference.md)
* [Smart Health Checks Patch AllergyIntolerance(https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance)](StructureDefinition-SHCPatchAllergyIntolerance.md)
* [Smart Health Checks Patch Condition(https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition)](StructureDefinition-SHCPatchCondition.md)
* [Smart Health Checks Patch MedicationStatement(https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement)](StructureDefinition-SHCPatchMedicationStatement.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Bundle.entry (Closed)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Bundle](http://hl7.org/fhir/R4/bundle.html) 

**Summary**

Mandatory: 2 elements(6 nested mandatory elements)
 Must-Support: 14 elements
 Fixed: 3 elements

**Structures**

This structure refers to these other structures:

* [Smart Health Checks AllergyIntolerance(https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance)](StructureDefinition-SHCAllergyIntolerance.md)
* [Smart Health Checks Condition(https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition)](StructureDefinition-SHCCondition.md)
* [Smart Health Checks Immunization(https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization)](StructureDefinition-SHCImmunization.md)
* [Smart Health Checks MedicationStatement(https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement)](StructureDefinition-SHCMedicationStatement.md)
* [Smart Health Checks Blood Pressure(https://smartforms.csiro.au/ig/StructureDefinition/SHCBloodPressure)](StructureDefinition-SHCBloodPressure.md)
* [Smart Health Checks Body Height(https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyHeight)](StructureDefinition-SHCBodyHeight.md)
* [Smart Health Checks Body Weight(https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight)](StructureDefinition-SHCBodyWeight.md)
* [Smart Health Checks Heart Rate(https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRate)](StructureDefinition-SHCHeartRate.md)
* [Smart Health Checks Heart Rhythm(https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRhythm)](StructureDefinition-SHCHeartRhythm.md)
* [Smart Health Checks Smoking Status(https://smartforms.csiro.au/ig/StructureDefinition/SHCSmokingStatus)](StructureDefinition-SHCSmokingStatus.md)
* [Smart Health Checks Waist Circumference(https://smartforms.csiro.au/ig/StructureDefinition/SHCWaistCircumference)](StructureDefinition-SHCWaistCircumference.md)
* [Smart Health Checks Head Circumference(https://smartforms.csiro.au/ig/StructureDefinition/SHCHeadCircumference)](StructureDefinition-SHCHeadCircumference.md)
* [Smart Health Checks Patch AllergyIntolerance(https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance)](StructureDefinition-SHCPatchAllergyIntolerance.md)
* [Smart Health Checks Patch Condition(https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition)](StructureDefinition-SHCPatchCondition.md)
* [Smart Health Checks Patch MedicationStatement(https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement)](StructureDefinition-SHCPatchMedicationStatement.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Bundle.entry (Closed)

 

Other representations of profile: [CSV](StructureDefinition-SHCExtractBundle.csv), [Excel](StructureDefinition-SHCExtractBundle.xlsx), [Schematron](StructureDefinition-SHCExtractBundle.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

