# Smart Health Checks Body Weight - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Body Weight**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-SHCBodyWeight-definitions.md) 
*  [Mappings](StructureDefinition-SHCBodyWeight-mappings.md) 
*  [XML](StructureDefinition-SHCBodyWeight.profile.xml.md) 
*  [JSON](StructureDefinition-SHCBodyWeight.profile.json.md) 
*  [TTL](StructureDefinition-SHCBodyWeight.profile.ttl.md) 

## Resource Profile: Smart Health Checks Body Weight 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksBodyWeight |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for a Body Weight resource to record, search and save body weight information when used within Smart Health Checks. 

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCBodyWeight)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCoreBodyWeight](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-bodyweight.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCoreBodyWeight](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-bodyweight.html) 

**Summary**

Must-Support: 3 elements

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [AUCoreBodyWeight](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-bodyweight.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [AUCoreBodyWeight](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-bodyweight.html) 

**Summary**

Must-Support: 3 elements

 

Other representations of profile: [CSV](StructureDefinition-SHCBodyWeight.csv), [Excel](StructureDefinition-SHCBodyWeight.xlsx), [Schematron](StructureDefinition-SHCBodyWeight.sch) 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

