# Questionnaire Item Text Hidden - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire Item Text Hidden**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-QuestionnaireItemTextHidden-definitions.md) 
*  [Mappings](StructureDefinition-QuestionnaireItemTextHidden-mappings.md) 
*  [XML](StructureDefinition-QuestionnaireItemTextHidden.profile.xml.md) 
*  [JSON](StructureDefinition-QuestionnaireItemTextHidden.profile.json.md) 
*  [TTL](StructureDefinition-QuestionnaireItemTextHidden.profile.ttl.md) 

## Extension: Questionnaire Item Text Hidden 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:QuestionnaireItemTextHidden |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This custom extension is used to indicate that the text of a Questionnaire item should be hidden in the user interface. This is useful for items where the text is not intended to be displayed to the user but is still needed for other processes.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md), [AbsoluteCVDRiskCalculation](Questionnaire-AbsoluteCVDRiskCalculation.md), [AllergiesAdverseReactions](Questionnaire-AllergiesAdverseReactions.md), [Examination](Questionnaire-Examination.md)...Show 4 more,[MedicalHistoryCurrentProblems](Questionnaire-MedicalHistoryCurrentProblems.md),[PatientDetails](Questionnaire-PatientDetails.md),[RegularMedications](Questionnaire-RegularMedications.md)and[SubstanceUse](Questionnaire-SubstanceUse.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/QuestionnaireItemTextHidden)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type boolean: This custom extension is used to indicate that the text of a Questionnaire item should be hidden in the user interface. This is useful for items where the text is not intended to be displayed to the user but is still needed for other processes.

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type boolean: This custom extension is used to indicate that the text of a Questionnaire item should be hidden in the user interface. This is useful for items where the text is not intended to be displayed to the user but is still needed for other processes.

 

Other representations of profile: [CSV](StructureDefinition-QuestionnaireItemTextHidden.csv), [Excel](StructureDefinition-QuestionnaireItemTextHidden.xlsx), [Schematron](StructureDefinition-QuestionnaireItemTextHidden.sch) 

#### Constraints

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

