# Group Hide Add Item Button - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Group Hide Add Item Button**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-GroupHideAddItemButton-definitions.md) 
*  [Mappings](StructureDefinition-GroupHideAddItemButton-mappings.md) 
*  [XML](StructureDefinition-GroupHideAddItemButton.profile.xml.md) 
*  [JSON](StructureDefinition-GroupHideAddItemButton.profile.json.md) 
*  [TTL](StructureDefinition-GroupHideAddItemButton.profile.ttl.md) 

## Extension: Group Hide Add Item Button 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:GroupHideAddItemButton |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This custom extension is used to hide the UI component that allows a user to add new items for repeating groups in a Questionnaire. This is useful for preventing users from adding additional groups when it is not appropriate to do so, such as when a group is intended to be prepopulated with existing data but no new ones added by the user.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md), [AllergiesAdverseReactions](Questionnaire-AllergiesAdverseReactions.md), [MedicalHistoryCurrentProblems](Questionnaire-MedicalHistoryCurrentProblems.md) and [RegularMedications](Questionnaire-RegularMedications.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/GroupHideAddItemButton)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type boolean: This custom extension is used to hide the UI component that allows a user to add new items for repeating groups in a Questionnaire. This is useful for preventing users from adding additional groups when it is not appropriate to do so, such as when a group is intended to be prepopulated with existing data but no new ones added by the user.

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type boolean: This custom extension is used to hide the UI component that allows a user to add new items for repeating groups in a Questionnaire. This is useful for preventing users from adding additional groups when it is not appropriate to do so, such as when a group is intended to be prepopulated with existing data but no new ones added by the user.

 

Other representations of profile: [CSV](StructureDefinition-GroupHideAddItemButton.csv), [Excel](StructureDefinition-GroupHideAddItemButton.xlsx), [Schematron](StructureDefinition-GroupHideAddItemButton.sch) 

#### Constraints

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

