# Contained Resource Reference - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contained Resource Reference**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-ContainedResourceReference-definitions.md) 
*  [Mappings](StructureDefinition-ContainedResourceReference-mappings.md) 
*  [XML](StructureDefinition-ContainedResourceReference.profile.xml.md) 
*  [JSON](StructureDefinition-ContainedResourceReference.profile.json.md) 
*  [TTL](StructureDefinition-ContainedResourceReference.profile.ttl.md) 

## Extension: Contained Resource Reference 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:ContainedResourceReference |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md) and [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AssemblyInstructions.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/ContainedResourceReference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Reference: This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server.

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type Reference: This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server.

 

Other representations of profile: [CSV](StructureDefinition-ContainedResourceReference.csv), [Excel](StructureDefinition-ContainedResourceReference.xlsx), [Schematron](StructureDefinition-ContainedResourceReference.sch) 

#### Constraints

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

