# pat-sf - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pat-sf**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](Patient-pat-sf.xml.md) 
*  [JSON](Patient-pat-sf.json.md) 
*  [TTL](Patient-pat-sf.ttl.md) 

## Example Patient: pat-sf

Profile: [Smart Health Checks Patient](StructureDefinition-SHCPatient.md)

Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))

-------

| | |
| :--- | :--- |
| Other Id: | IHI/8003608833357361 |
| Alt. Name: | Mrs. Smart Form(Official) |
| Contact Detail | * ph: 0491 572 665(Mobile)
* ph: 0123456879(Home)
* 4 Brisbane Street Brisbane QLD 4112 AU (home)
* PO Box Number Brisbane QLD 4112 AU (temp)
 |
| Language: | Yugambal |
| Emergency Contact: | * Ms Phone A Friend
* ph: 0987654321
 |
| Individual Pronouns: | * value: they/them/their/theirs/themselves
* period: 2018-02 --> 2022-06
 |
| Individual Pronouns: | * value: she/her/her/hers/herself
* period: 2022-06 --> (ongoing)
 |
| Person Recorded Sex Or Gender: | * value: Female
* type: Sex at Birth
* effectivePeriod: 2022-06 --> (ongoing)
 |
| Person Recorded Sex Or Gender: | * value: Indeterminate sex
* type: Sex at Birth
* effectivePeriod: 2018-02 --> 2022-06
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1 1: Aboriginal but not Torres Strait Islander origin |
| Individual Gender Identity: | * value: Identifies as female gender
 |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

