# SHC App - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SHC App**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](CapabilityStatement-SHCAppCapabilityStatement.xml.md) 
*  [JSON](CapabilityStatement-SHCAppCapabilityStatement.json.md) 
*  [TTL](CapabilityStatement-SHCAppCapabilityStatement.ttl.md) 

## CapabilityStatement: SHC App 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CapabilityStatement/SHCAppCapabilityStatement | *Version*:0.3.0 |
| Draft as of 2025-04-16 | *Computable Name*:SHCApp |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This CapabilityStatement describes the capabilities of the SHC App. These capabilities include supported FHIR profiles, RESTful operations, and search parameters. It covers supported tasks such as SMART App launch context, prepopulation, write-back of extracted resources and completion of forms. 

 [Raw OpenAPI-Swagger Definition file](SHCAppCapabilityStatement.openapi.json) | [Download](SHCAppCapabilityStatement.openapi.json) 

## SHC App

* Implementation Guide Version: 0.3.0 
* FHIR Version: 4.0.1 
* Supported Formats: `json`
* Supported Patch Formats: `application/fhir+json`
* Published on: 2025-04-16 
* Published by: AEHRC CSIRO 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

This CapabilityStatement instantiates these CapabilityStatements [SDC Form Filler](https://build.fhir.org/ig/HL7/sdc/CapabilityStatement-sdc-form-filler.html), [AU Core Requester CapabilityStatement](http://hl7.org.au/fhir/core/2.0.0-ballot/CapabilityStatement-au-core-requester.html)

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch|2.2.0](http://hl7.org/fhir/smart-app-launch/STU2.2/index.html)

## FHIR RESTful Capabilities

### Mode: client

The SHC App performs interactions to support SMART App Launch, form prepopulation, write-back of extracted resources and form filling.

**Security**

Enable CORS: yes

Security services supported:
`SMART-on-FHIR`

> 

SMART App Launch supported to allow secure data exchange.


**Summary of System-wide Interactions**

* Supports the `transaction`interaction.
* Supports the `batch`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AllergyIntolerance](#AllergyIntolerance1-1) | Supported Profiles  [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md) |  | y |  | y | y | patient |  |  |  |
| [Bundle](#Bundle1-2) | Supported Profiles  [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md) |  |  |  |  |  |  |  |  |  |
| [Condition](#Condition1-3) | Supported Profiles  [Smart Health Checks Condition](StructureDefinition-SHCCondition.md) |  | y |  | y | y | patient, category |  |  |  |
| [Encounter](#Encounter1-4) | Supported Profiles  [Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md) | y |  |  |  |  |  |  |  |  |
| [Immunization](#Immunization1-5) | Supported Profiles  [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md) |  | y |  |  | y | patient, status |  |  |  |
| [Medication](#Medication1-6) | Supported Profiles  [Smart Health Checks Medication](StructureDefinition-SHCMedication.md) | y |  |  |  |  |  |  |  |  |
| [MedicationStatement](#MedicationStatement1-7) | Supported Profiles  [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md) |  | y |  | y | y | patient, status, _include | `MedicationStatement:medication` |  |  |
| [Observation](#Observation1-8) | Supported Profiles  [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)  [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)  [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)  [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)  [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)  [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)  [Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)  [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)  [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md) |  | y |  |  | y | patient, code, _sort |  |  |  |
| [Parameters](#Parameters1-9) | Supported Profiles  [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)  [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)  [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md) |  |  |  |  |  |  |  |  |  |
| [Patient](#Patient1-10) | Supported Profiles  [Smart Health Checks Patient](StructureDefinition-SHCPatient.md) | y |  |  |  |  |  |  |  |  |
| [Practitioner](#Practitioner1-11) | Supported Profiles  [Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md) | y |  |  |  |  |  |  |  |  |
| [Questionnaire](#Questionnaire1-12) | [http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire.html) |  | y |  |  | y | url, version, title, _count, _sort |  |  | `$assemble`,`$populate` |
| [QuestionnaireResponse](#QuestionnaireResponse1-13) | [https://smartforms.csiro.au/ig/StructureDefinition/SHCQuestionnaireResponse](StructureDefinition-SHCQuestionnaireResponse.md) | y | y | y |  | y | patient, questionnaire, status, _count, _sort |  |  |  |
| [ValueSet](#ValueSet1-14) |   |  |  |  |  |  |  |  |  | `$expand` |

-------

#### Resource Conformance: supported AllergyIntolerance

Core FHIR Resource

[AllergyIntolerance](http://hl7.org/fhir/R4/allergyintolerance.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)

Documentation
> 

The client supports the AllergyIntolerance resource, the Smart Health Checks profile and the conformance expectations for the AllergyIntolerance resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/allergyintolerance.html#search) | `reference` |

#### Resource Conformance: supported Bundle

Core FHIR Resource

[Bundle](http://hl7.org/fhir/R4/bundle.html)

Reference Policy

Interaction summary

Supported Profiles
[Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)

Documentation
> 

The client supports the Bundle resource, the Smart Health Checks profile listed and the conformance expectations for the Bundle resource.


#### Resource Conformance: supported Condition

Core FHIR Resource

[Condition](http://hl7.org/fhir/R4/condition.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

Documentation
> 

The client supports the Condition resource, the Smart Health Checks and the conformance expectations for the Condition resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/condition.html#search)+[category](http://hl7.org/fhir/R4/condition.html#search) | `reference`+`token` |

#### Resource Conformance: supported Encounter

Core FHIR Resource

[Encounter](http://hl7.org/fhir/R4/encounter.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md)

Documentation
> 

The client supports the Encounter resource, the Smart Health Checks profile and the conformance expectations for the Encounter resource.


#### Resource Conformance: supported Immunization

Core FHIR Resource

[Immunization](http://hl7.org/fhir/R4/immunization.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`.

Supported Profiles
[Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md)

Documentation
> 

The client supports the Immunization resource, the Smart Health Checks profile and the conformance expectations for the Immunization resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/immunization.html#search)+[status](http://hl7.org/fhir/R4/immunization.html#search) | `reference`+`token` |

#### Resource Conformance: supported Medication

Core FHIR Resource

[Medication](http://hl7.org/fhir/R4/medication.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Medication](StructureDefinition-SHCMedication.md)

Documentation
> 

The client supports the Medication resource, the Smart Health Checks profile and the conformance expectations for the Medication resource.


#### Resource Conformance: supported MedicationStatement

Core FHIR Resource

[MedicationStatement](http://hl7.org/fhir/R4/medicationstatement.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

Documentation
> 

The client supports the MedicationStatement resource, the Smart Health Checks profile and the conformance expectations for the MedicationStatement resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/medicationstatement.html#search)+[status](http://hl7.org/fhir/R4/medicationstatement.html#search) | `reference`+`token` |
|   | [patient](http://hl7.org/fhir/R4/medicationstatement.html#search)+[status](http://hl7.org/fhir/R4/medicationstatement.html#search)+_include | `reference`+`token`+`reference` |

#### Resource Conformance: SHALL Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`.

Supported Profiles
[Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)
[Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)
[Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)
[Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)
[Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)
[Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)
[Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)
[Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)
[Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md)

Documentation
> 

The client supports the Observation resource, the Smart Health Checks profiles listed and the conformance expectations for the Observation resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/observation.html#search)+[code](http://hl7.org/fhir/R4/observation.html#search)+_sort | `reference`+`token`+`string` |

#### Resource Conformance: supported Parameters

Core FHIR Resource

[Parameters](http://hl7.org/fhir/R4/parameters.html)

Reference Policy

Interaction summary

Supported Profiles
[Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)
[Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)
[Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

Documentation
> 

The client supports the Parameters resource, the Smart Health Checks profiles listed and the conformance expectations for the Parameters resource.


#### Resource Conformance: supported Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Patient](StructureDefinition-SHCPatient.md)

Documentation
> 

The client supports the Patient resource, Smart Health Checks profile and the conformance expectations for the Patient resource.


#### Resource Conformance: supported Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md)

Documentation
> 

The client supports the Practitioner resource, Smart Health Checks profile and the conformance expectations for the Practitioner resource.


#### Resource Conformance: supported Questionnaire

Base System Profile

[SDC Base Questionnaire](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire.html)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `search-type`, `create`.

Documentation
> 

The client supports the Questionnaire resource, Structured Data Capture profile and the conformance expectations for the Questionnaire resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [url](http://hl7.org/fhir/R4/questionnaire.html#search)+[version](http://hl7.org/fhir/R4/questionnaire.html#search) | `uri`+`token` |
|   | _count+_sort | `number`+`string` |
|   | [title](http://hl7.org/fhir/R4/questionnaire.html#search)+_count+_sort | `string`+`number`+`string` |

Extended Operations


#### Resource Conformance: supported QuestionnaireResponse

Base System Profile

[Smart Health Checks Questionnaire Response](StructureDefinition-SHCQuestionnaireResponse.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`, `create`, `update`.

Documentation
> 

The client supports the QuestionnaireResponse resource, Smart Health Checks profile and the conformance expectations for the QuestionnaireResponse resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/questionnaireresponse.html#search)+_count+_sort | `reference`+`number`+`string` |
|   | [patient](http://hl7.org/fhir/R4/questionnaireresponse.html#search)+_count+_sort+[questionnaire](http://hl7.org/fhir/R4/questionnaireresponse.html#search) | `reference`+`number`+`string`+`reference` |
|   | [patient](http://hl7.org/fhir/R4/questionnaireresponse.html#search)+_count+_sort+[status](http://hl7.org/fhir/R4/questionnaireresponse.html#search) | `reference`+`number`+`string`+`token` |

#### Resource Conformance: supported ValueSet

Core FHIR Resource

[ValueSet](http://hl7.org/fhir/R4/valueset.html)

Reference Policy

Interaction summary

Documentation
> 

The client supports the ValueSet resource and the conformance expectations for the ValueSet resource.


Extended Operations


 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

