# sdc-template-extract-928bbdd27d15 - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **sdc-template-extract-928bbdd27d15**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-sdc-template-extract-928bbdd27d15.xml.md) 
*  [JSON](Bundle-sdc-template-extract-928bbdd27d15.json.md) 
*  [TTL](Bundle-sdc-template-extract-928bbdd27d15.ttl.md) 

## Example Bundle: sdc-template-extract-928bbdd27d15

Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)

Tag: @aehrc/sdc-template-extract-v0.1.0:generated (Details: [not stated] code @aehrc/sdc-template-extract-v0.1.0:generated)

Bundle sdc-template-extract-928bbdd27d15 of type transaction

-------

Entry 1 - fullUrl = urn:uuid:c618ee3d-b07b-4711-90f5-56d934b906de

Resource Condition:

> 

Profile: [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

**clinicalStatus**:Active**category**:Problem List Item**code**:Asthma**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**onset**: 2025-07-01**note**:
> 

Difficulty breathing



Request:

```
POST Condition

```

-------

Entry 2 - fullUrl = urn:uuid:81c413e3-46e4-4f9f-96f5-c71983f6ffcd

Resource Condition:

> 

Profile: [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

**clinicalStatus**:Active**category**:Problem List Item**code**:Really bad pain**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**onset**: 2025-08-13

Request:

```
POST Condition

```

-------

Entry 3 - fullUrl = urn:uuid:ffb87c39-5fa8-4ea7-92c1-83911ecf33a7

Resource Parameters:

> 

Profile: [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)

## Parameters


Request:

```
PATCH Condition/fever-pat-sf

```

-------

Entry 4 - fullUrl = urn:uuid:f23b4046-2326-4c86-b4f6-1e8b6f6f7321

Resource MedicationStatement:

> 

Profile: [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

**status**: active**status**: recorded**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**dateAsserted**: 2025-08-15 10:08:34+1000**note**:
> 

Review regularly


### Dosages

| | |
| :--- | :--- |
| - | **Text** |
| * | One tablet daily |


Request:

```
POST MedicationStatement

```

-------

Entry 5 - fullUrl = urn:uuid:319646e0-cba5-405f-9b2d-b64f22c12876

Resource Parameters:

> 

Profile: [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

## Parameters


Request:

```
PATCH MedicationStatement/chloramphenicol-pat-sf

```

-------

Entry 6 - fullUrl = urn:uuid:c8a97d6f-d0d5-4561-ab83-2607b3bb072f

Resource Parameters:

> 

Profile: [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

## Parameters


Request:

```
PATCH MedicationStatement/active-bisoprolol-pat-sf

```

-------

Entry 7 - fullUrl = urn:uuid:e1f31c73-cb18-4ddd-aacb-26d59de074ba

Resource AllergyIntolerance:

> 

Profile: [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)

**clinicalStatus**:Active**code**:Aspirin**patient**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**note**:
> 

Moderate reaction


### Reactions

| | |
| :--- | :--- |
| - | **Manifestation** |
| * | No display for AllergyIntolerance.reaction.manifestation (concept: Urticaria) |


Request:

```
POST AllergyIntolerance

```

-------

Entry 8 - fullUrl = urn:uuid:346d80b8-9aef-42eb-a794-bbb74774ff7f

Resource Parameters:

> 

Profile: [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)

## Parameters


Request:

```
PATCH AllergyIntolerance/604a-pat-sf

```

-------

Entry 9 - fullUrl = urn:uuid:29c3f6e2-4789-4114-8faf-95d250fc1986

Resource Observation:

> 

Profile: [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)

**status**: Final**category**:Social History**code**:Smoking status**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**:Ex-smoker

Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = urn:uuid:9c321cfb-0218-455e-a44b-4c6c65afc40e

Resource Immunization:

> 

Profile: [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md)

**status**: Completed**vaccineCode**:Fluquadri 2025**lotNumber**: 123**patient**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**occurrence**: 2025-08-15

Request:

```
POST Immunization

```

-------

Entry 11 - fullUrl = urn:uuid:559e4dda-ee0d-46c2-9f32-0bb66d9ae5e2

Resource Observation:

> 

Profile: [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)

**status**: Final**category**:Vital Signs**code**:Height**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 164 cm(Details: UCUM codecm = 'cm')

Request:

```
POST Observation

```

-------

Entry 12 - fullUrl = urn:uuid:20e79d0a-17cc-4e0a-9507-b441815ec266

Resource Observation:

> 

Profile: [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)

**status**: Final**category**:Vital Signs**code**:Weight**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 80 kg(Details: UCUM codekg = 'kg')

Request:

```
POST Observation

```

-------

Entry 13 - fullUrl = urn:uuid:553b15aa-fa22-4290-bcfb-f683ad6d6674

Resource Observation:

> 

Profile: [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md)

**status**: Final**category**:Vital Signs**code**:Waist circumference**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 90 cm(Details: UCUM codecm = 'cm')

Request:

```
POST Observation

```

-------

Entry 14 - fullUrl = urn:uuid:1d0cce77-432d-42d7-a9be-5711972e7953

Resource Observation:

> 

Profile: [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)

**status**: Final**category**:Vital Signs**code**:Heart rate**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 75 /min(Details: UCUM code/min = '/min')

Request:

```
POST Observation

```

-------

Entry 15 - fullUrl = urn:uuid:3583d16f-a22f-4f03-8251-1d5d04ea87de

Resource Observation:

> 

Profile: [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)

**status**: Final**category**:Vital Signs**code**:Heart rhythm**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**:Regular heart rhythm

Request:

```
POST Observation

```

-------

Entry 16 - fullUrl = urn:uuid:37e726d5-6ccd-4c81-ad8f-abc3460a645f

Resource Observation:

> 

Profile: [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)

**status**: Final**category**:Vital Signs**code**:Blood pressure**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15
> **component****code**:Systolic**value**: 170 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Diastolic**value**: 90 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

Request:

```
POST Observation

```

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

