# SHC Host Authorization Server - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SHC Host Authorization Server**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](ActorDefinition-SHCHostAuthorizationServer.xml.md) 
*  [JSON](ActorDefinition-SHCHostAuthorizationServer.json.md) 
*  [TTL](ActorDefinition-SHCHostAuthorizationServer.ttl.md) 

## ActorDefinition: SHC Host Authorization Server 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ActorDefinition/SHCHostAuthorizationServer | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SHCHostAuthorizationServer |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The SHC Host Authorization Server allows the SHC App to request authorisation from the PMS user to access patient health information to prepopulate and write back health checks data using the PMS FHIR Server. 

* **Actor: SHCHostAuthorizationServer**: The SHC Host Authorization Server:* **SHALL** respond to [Authorization Request](https://hl7.org/fhir/smart-app-launch/app-launch.html#obtain-authorization-code)
* **SHALL** respond to [Token Request](https://hl7.org/fhir/smart-app-launch/app-launch.html#obtain-access-token)
* **SHALL** support SMART App Launch scopes: 
* openid fhirUser
* launch
* user/Practitioner.r
* patient/Patient.r
* patient/*.rs
* user/QuestionnaireResponse.crus
* ...
 


### Notes:

#### SHC Host Authorization Server Interactions

##### Authorization Request

The Health Check App responds to the PMS browser to redirect to the authorization URL with the required authorization request parameters including the response_type, client_id, redirect_uri, scope, aud, state, code_challenge, code_challenge_method and launch. The Authorization Server, if required by PMS organization policies, may respond with a data access consent form where the PMS User grants the App access to the requested data.

##### Authorization Callback

When granted, the Authorization Server response redirects the PMS browser back to the Health Check App authorization callback (redirect_uri) endpoint with a code parameter.

##### Token Request

The Health Check App authorization callback extracts the code parameter and uses the token_endpoint URL to exchange it for an access token. The HTTP POST request body includes the required parameters including the code, grant_type, client_id, redirect_uri and code_verifier.

The Authorization Server response contains the token_type, access_token, id_token, scope and the relevant launch context data stashed by the PMS such as patient, encounter and health check questionnaire, which can be used to retrieve by Id the respective FHIR resources from the PMS FHIR API.

The id_token is a signed JWT that contains an encoding of user details, including a fhirUser reference that can be used to retrieve from the FHIR API a FHIR resource representing the user.

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

