# SHC App - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SHC App**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](ActorDefinition-SHCApp.xml.md) 
*  [JSON](ActorDefinition-SHCApp.json.md) 
*  [TTL](ActorDefinition-SHCApp.ttl.md) 

## ActorDefinition: SHC App 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ActorDefinition/SHCApp | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SHCApp |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The SHC App is a system that a SHC Host can launch allowing a user to fill out a health check form, prepopulated with patient health information retrieved from the SHC Host FHIR Server, and writeback data collected in the form. 

* **Actor: SHCApp**: The Smart Health Checks (SHC) App:* **SHALL** accept [App Launch](https://hl7.org/fhir/smart-app-launch/app-launch.html#launch-app-ehr-launch) request
* **SHALL** invoke [SMART Authorization Configuration](https://hl7.org/fhir/smart-app-launch/app-launch.html#retrieve-well-knownsmart-configuration) request
* **SHALL** redirect to [Authorization Request](https://hl7.org/fhir/smart-app-launch/app-launch.html#obtain-authorization-code)
* **SHALL** accept Authorization Callback request
* **SHALL** invoke [Token Request](https://hl7.org/fhir/smart-app-launch/app-launch.html#obtain-access-token)
* **SHALL** authorise FHIR API requests using Bearer access token per [SMART APP Launch Access FHIR API](https://hl7.org/fhir/smart-app-launch/app-launch.html#access-fhir-api)
* **SHALL** invoke read Practitioner request
* **SHALL** invoke read Patient request
* **SHALL** invoke search QuestionnaireResponse request
* **SHALL** invoke read QuestionnaireResponse request
* **SHALL** invoke create and update QuestionnaireResponse request
* **SHALL** invoke search and read requests for resources required by this IG to pre-populate questionnaire response
* **SHALL** invoke create and patch requests in a transaction Bundle for resources required by this IG

* **Actor: SHCApp**: Capabilities:
  * SHC App: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md)
* **Actor: SHCApp**: Derived from:
  * SHC App: [http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester](http://hl7.org.au/fhir/core/2.0.0-ballot/ActorDefinition-au-core-actor-requester.html)

### Notes:

#### SHC App Interactions

##### App Launch

The SHC user initiates the SHC App within the PMS. The PMS generates a launch context related to the current user, patient and health check questionnaire, which the SHC Host Authorization Server can access from the parameter provided in the App launch request.

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

