# GP CCMP Questionnaire Response - GP Chronic Condition Management Plan v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GP CCMP Questionnaire Response**

## Resource Profile: GP CCMP Questionnaire Response 

| | |
| :--- | :--- |
| *Official URL*:https://gpccmp.csiro.au/ig/StructureDefinition/GPCCMPQuestionnaireResponse | *Version*:0.1.0 |
| Draft as of 2026-01-28 | *Computable Name*:GPCCMPQuestionnaireResponse |

 
This profile sets the minimum expectations for a QuestionnaireResponse resource to record, search and save GP Chronic Condition Management Plan information. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.gpccmp|current/StructureDefinition/GPCCMPQuestionnaireResponse)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-GPCCMPQuestionnaireResponse.csv), [Excel](StructureDefinition-GPCCMPQuestionnaireResponse.xlsx), [Schematron](StructureDefinition-GPCCMPQuestionnaireResponse.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "GPCCMPQuestionnaireResponse",
  "url" : "https://gpccmp.csiro.au/ig/StructureDefinition/GPCCMPQuestionnaireResponse",
  "version" : "0.1.0",
  "name" : "GPCCMPQuestionnaireResponse",
  "title" : "GP CCMP Questionnaire Response",
  "status" : "draft",
  "date" : "2026-01-28T04:53:48+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        }
      ]
    }
  ],
  "description" : "This profile sets the minimum expectations for a QuestionnaireResponse resource to record, search and save GP Chronic Condition Management Plan information.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "QuestionnaireResponse",
  "baseDefinition" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "QuestionnaireResponse",
        "path" : "QuestionnaireResponse"
      },
      {
        "id" : "QuestionnaireResponse.id",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.id",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.text",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.questionnaire",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.questionnaire"
      },
      {
        "id" : "QuestionnaireResponse.questionnaire.extension:questionnaireDisplay",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.questionnaire.extension",
        "sliceName" : "questionnaireDisplay"
      },
      {
        "id" : "QuestionnaireResponse.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.status"
      },
      {
        "id" : "QuestionnaireResponse.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.encounter",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.encounter",
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.authored",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.authored"
      },
      {
        "id" : "QuestionnaireResponse.author",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.author",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Practitioner"]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.item",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.item"
      },
      {
        "id" : "QuestionnaireResponse.item.linkId",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.item.linkId"
      },
      {
        "id" : "QuestionnaireResponse.item.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.item.text"
      },
      {
        "id" : "QuestionnaireResponse.item.answer",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.item.answer"
      },
      {
        "id" : "QuestionnaireResponse.item.answer.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.item.answer.value[x]"
      },
      {
        "id" : "QuestionnaireResponse.item.item",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://gpccmp.csiro.au/ig/ActorDefinition/GPCCMPClient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "QuestionnaireResponse.item.item"
      }
    ]
  }
}

```
