# GP Chronic Condition Management Plan - GP Chronic Condition Management Plan v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GP Chronic Condition Management Plan**

## Questionnaire: GP Chronic Condition Management Plan 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/GPChronicConditionManagementPlan | *Version*:0.1.0 |
| Draft as of 2025-12-05 | *Computable Name*:GPChronicConditionManagementPlan |

 
GP Chronic Condition Management Plan 



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "GPChronicConditionManagementPlan",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-render",
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-pop-exp"
    ]
  },
  "contained" : [
    {
      "resourceType" : "ValueSet",
      "id" : "YesNoNA",
      "url" : "https://gpccmp.csiro.au/ig/ValueSet/YesNoNA",
      "name" : "YesNoNA",
      "title" : "Yes/No/NA",
      "status" : "draft",
      "experimental" : false,
      "description" : "Concepts for Yes, No and Not applicable",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "concept" : [
              {
                "code" : "Y",
                "display" : "Yes"
              },
              {
                "code" : "N",
                "display" : "No"
              },
              {
                "code" : "NA",
                "display" : "not applicable"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:b0d3ebde-96ab-4f8f-bb5e-063a45acdcff",
        "timestamp" : "2025-12-11T11:44:01+10:00",
        "total" : 3,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "N",
            "display" : "No"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "NA",
            "display" : "not applicable"
          }
        ]
      }
    }
  ],
  "extension" : [
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "patient"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Patient"
        },
        {
          "url" : "description",
          "valueString" : "The patient that is to be used to pre-populate the form. This is the subject of the form."
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "user"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Practitioner"
        },
        {
          "url" : "description",
          "valueString" : "The practitioner user that is to be used to pre-populate the form. This is the user that is filling out the form."
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "encounter"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Encounter"
        },
        {
          "url" : "description",
          "valueString" : "The encounter that is to be used to pre-populate the form. This is the encounter during which the form is being filled out."
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "https://gpccmp.csiro.au/ig/CodeSystem/LaunchContextExtended",
            "code" : "gpccmppractitionerrole"
          }
        },
        {
          "url" : "type",
          "valueCode" : "PractitionerRole"
        },
        {
          "url" : "description",
          "valueString" : "The practitioner role that is to be used to pre-populate the form. This is the practitioner role of the user that is filling out the form."
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "GPCCMPLatest",
        "language" : "application/x-fhir-query",
        "expression" : "QuestionnaireResponse?questionnaire=http://www.health.gov.au/assessments/GPChronicConditionManagementPlan&_count=1&_sort=-authored&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "GPCCMPLatestCompleted",
        "language" : "application/x-fhir-query",
        "expression" : "QuestionnaireResponse?questionnaire=http://www.health.gov.au/assessments/GPChronicConditionManagementPlan&status=completed&_count=1&_sort=-authored&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "PractitionerRole",
        "language" : "application/x-fhir-query",
        "expression" : "PractitionerRole?practitioner={{%user.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "Condition",
        "language" : "application/x-fhir-query",
        "expression" : "Condition?patient={{%patient.id}}&category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "AllergyIntolerance",
        "language" : "application/x-fhir-query",
        "expression" : "AllergyIntolerance?patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "MedicationStatement",
        "language" : "application/x-fhir-query",
        "expression" : "MedicationStatement?patient={{%patient.id}}&status=active&_include=MedicationStatement:medication"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeight",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=8302-2&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeight",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=29463-7&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumference",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=8280-0&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRate",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=8867-4&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythm",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=364074009&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsOxygenSaturation",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=2708-6&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressure",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=85354-9&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsSmokingStatus",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=1747861000168109&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "age",
        "language" : "text/fhirpath",
        "expression" : "repeat(item).where(linkId='patient-age').answer.value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "weight",
        "language" : "text/fhirpath",
        "expression" : "repeat(item).where(linkId='clinicalhistory-observations-maingrid-weight-value').answer.value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "height",
        "language" : "text/fhirpath",
        "expression" : "repeat(item).where(linkId='clinicalhistory-observations-maingrid-height-value').answer.value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "medicationsFromContained",
        "language" : "text/fhirpath",
        "expression" : "%MedicationStatement.entry.resource.contained.ofType(Medication).where(id in %MedicationStatement.entry.resource.medication.select(reference.replace('#', '')))"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "medicationsFromRef",
        "language" : "text/fhirpath",
        "expression" : "%MedicationStatement.entry.resource.ofType(Medication).where(id in %MedicationStatement.entry.resource.medication.select(reference.replace('Medication/', '')))"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeightLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyHeight.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeightLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyWeight.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumferenceLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsWaistCircumference.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRateLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRate.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythmLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRhythm.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsOxygenSaturationLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsOxygenSaturation.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressureLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsBloodPressure.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsSmokingStatusLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsSmokingStatus.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Questionnaire.versionAlgorithm[x]",
      "valueCoding" : {
        "system" : "http://hl7.org/fhir/version-algorithm",
        "code" : "semver"
      }
    }
  ],
  "url" : "http://www.health.gov.au/assessments/GPChronicConditionManagementPlan",
  "version" : "0.1.0",
  "name" : "GPChronicConditionManagementPlan",
  "title" : "GP Chronic Condition Management Plan",
  "status" : "draft",
  "experimental" : false,
  "subjectType" : ["Patient"],
  "date" : "2025-12-05",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        }
      ]
    }
  ],
  "description" : "GP Chronic Condition Management Plan",
  "item" : [
    {
      "linkId" : "container",
      "type" : "group",
      "repeats" : false,
      "item" : [
        {
          "linkId" : "instructions",
          "text" : "This GP Chronic Condition Management Plan has been prefilled with information that was available from the patient's health record. Upon saving this form, the form will be stored but additional information entered will not be used to update the patient's health record.",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n    <p style=\"font-size:1.2em; font-weight:normal\"><em>This GP Chronic Condition Management Plan has been prefilled with information that was available from the patient's health record. Upon saving this form, the form will be stored but additional information entered will not be used to update the patient's health record.</em></p>\n    </div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
              "valueCode" : "default-closed"
            }
          ],
          "linkId" : "patient",
          "text" : "Patient details",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%patient.name.where(use='official').select((given.join(' ') | family).join(' ') | text) | %patient.name.select((given.join(' ') | family).join(' ') | text)).first()"
                  }
                }
              ],
              "linkId" : "patient-name",
              "text" : "Name",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%patient.name.where(use='usual').select((given.join(' ') | family).join(' ') | text)).first()"
                  }
                }
              ],
              "linkId" : "patient-preferredname",
              "text" : "Preferred name",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(exists(url='http://hl7.org/fhir/StructureDefinition/individual-pronouns') and extension.where(url='period').value.end.empty()).extension.where(url='value').value.coding"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "patient-preferredpronouns",
              "text" : "Preferred pronouns",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.birthDate"
                  }
                }
              ],
              "linkId" : "patient-dob",
              "text" : "Date of birth",
              "type" : "date",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "iif(today().toString().select(substring(5,2) & substring(8,2)).toInteger() > %patient.birthDate.toString().select(substring(5,2) & substring(8,2)).toInteger(), today().toString().substring(0,4).toInteger() - %patient.birthDate.toString().substring(0,4).toInteger(), today().toString().substring(0,4).toInteger() - %patient.birthDate.toString().substring(0,4).toInteger() - 1)"
                  }
                }
              ],
              "linkId" : "patient-age",
              "text" : "Age",
              "type" : "integer",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(exists(url='http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender' and extension.where(exists(url='type' and value.coding.code='1515311000168102')) and extension.where(url='effectivePeriod').value.end.empty())).extension.where(url='value').value.coding"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "patient-sexatbirth",
              "text" : "Sex assigned at birth",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(exists(url='http://hl7.org/fhir/StructureDefinition/individual-genderIdentity') and extension.where(url='period').value.end.empty()).extension.where(url='value').value.coding"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "patient-genderidentity",
              "text" : "Gender identity",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(url='http://hl7.org.au/fhir/StructureDefinition/indigenous-status').value"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "patient-firstnationsstatus",
              "text" : "Aboriginal and/or Torres Strait Islander status",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-indigenous-status-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(url='http://hl7.org.au/fhir/StructureDefinition/closing-the-gap-registration').value"
                  }
                }
              ],
              "linkId" : "patient-ctg",
              "text" : "Registered for Closing the Gap PBS Co-payment Measure (CTG)",
              "type" : "boolean",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50"
                  }
                }
              ],
              "linkId" : "patient-myagedcare",
              "text" : "My Aged Care",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "patient-myagedcare-registered",
                  "text" : "Registered for My Aged Care",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "patient-myagedcare-number",
                  "text" : "My Aged Care Number",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "patient-myagedcare-registered",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "patient-ndis",
              "text" : "National Disability Insurance Scheme",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "patient-ndis-registered",
                  "text" : "Registered for NDIS",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "patient-ndis-number",
                  "text" : "NDIS Number",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "patient-ndis-registered",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "MedicareNumberArray",
                    "language" : "text/fhirpath",
                    "expression" : "%patient.identifier.where(type.coding.exists(system='http://terminology.hl7.org/CodeSystem/v2-0203' and code='MC'))"
                  }
                }
              ],
              "linkId" : "patient-medicare",
              "text" : "Medicare number",
              "type" : "group",
              "repeats" : true,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicareNumberArray.value.substring(0,10)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                      "valueString" : "matches('^[0-9]{10}$')"
                    }
                  ],
                  "linkId" : "patient-medicare-number",
                  "text" : "Number",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicareNumberArray.value.substring(10,1)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                      "valueString" : "matches('^[0-9]{1}$')"
                    }
                  ],
                  "linkId" : "patient-medicare-referencenumber",
                  "text" : "Reference number",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicareNumberArray.period.end.toString()"
                      }
                    }
                  ],
                  "linkId" : "patient-medicare-expiry",
                  "text" : "Expiry",
                  "type" : "string",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "patient-contact",
              "text" : "Contact information",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%patient.telecom.where(all(system = 'email' and (use.empty() or use = 'home'))).value"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-email",
                  "text" : "Email",
                  "type" : "string",
                  "repeats" : true,
                  "readOnly" : true
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                      "valueExpression" : {
                        "name" : "HomeAddressArray",
                        "language" : "text/fhirpath",
                        "expression" : "%patient.address.where(all(use='home' and (type.empty() or type!='postal')))"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-homeaddress",
                  "text" : "Home address",
                  "type" : "group",
                  "repeats" : false,
                  "readOnly" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%HomeAddressArray.extension('http://hl7.org.au/fhir/StructureDefinition/no-fixed-address').value"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "check-box"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "patient-contact-homeaddress-nofixedaddress",
                      "text" : "No fixed address",
                      "type" : "boolean",
                      "repeats" : false
                    },
                    {
                      "linkId" : "patient-contact-homeaddress-details",
                      "text" : "Home address",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                            "valueBoolean" : true
                          }
                        ]
                      },
                      "type" : "group",
                      "enableWhen" : [
                        {
                          "question" : "patient-contact-homeaddress-nofixedaddress",
                          "operator" : "!=",
                          "answerBoolean" : true
                        }
                      ],
                      "repeats" : true,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%HomeAddressArray.select(line.join(', '))"
                              }
                            }
                          ],
                          "linkId" : "patient-contact-homeaddress-details-streetaddress",
                          "text" : "Street address",
                          "type" : "string",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%HomeAddressArray.city"
                              }
                            }
                          ],
                          "linkId" : "patient-contact-homeaddress-details-city",
                          "text" : "City",
                          "type" : "string",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%HomeAddressArray.state"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "drop-down"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "patient-contact-homeaddress-details-state",
                          "text" : "State",
                          "type" : "choice",
                          "repeats" : false,
                          "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%HomeAddressArray.postalCode"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                              "valueString" : "matches('^[0-9]{4}$')"
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                              "valueString" : "####"
                            }
                          ],
                          "linkId" : "patient-contact-homeaddress-details-postcode",
                          "text" : "Postcode",
                          "type" : "string",
                          "repeats" : false
                        }
                      ]
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                      "valueExpression" : {
                        "name" : "PostalAddressArray",
                        "language" : "text/fhirpath",
                        "expression" : "%patient.address.where(type='postal')"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%PostalAddressArray.exists()"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-postaladdress",
                  "text" : "Postal address",
                  "type" : "group",
                  "repeats" : true,
                  "readOnly" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%PostalAddressArray.use"
                          }
                        }
                      ],
                      "linkId" : "patient-contact-postaladdress-purpose",
                      "text" : "Purpose of use",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%PostalAddressArray.select(line.join(', '))"
                          }
                        }
                      ],
                      "linkId" : "patient-contact-postaladdress-streetaddress",
                      "text" : "Street address",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%PostalAddressArray.city"
                          }
                        }
                      ],
                      "linkId" : "patient-contact-postaladdress-city",
                      "text" : "City",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%PostalAddressArray.state"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "patient-contact-postaladdress-state",
                      "text" : "State",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%PostalAddressArray.postalCode"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                          "valueString" : "matches('^[0-9]{4}$')"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                          "valueString" : "####"
                        }
                      ],
                      "linkId" : "patient-contact-postaladdress-postcode",
                      "text" : "Postcode",
                      "type" : "string",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%patient.telecom.where(system = 'phone' and use = 'home').value"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-homephone",
                  "text" : "Home phone",
                  "type" : "string",
                  "repeats" : true,
                  "readOnly" : true
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%patient.telecom.where(system = 'phone' and use = 'mobile').value"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-mobilephone",
                  "text" : "Mobile phone",
                  "type" : "string",
                  "repeats" : true,
                  "readOnly" : true
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                      "valueExpression" : {
                        "name" : "EmergencyContactArray",
                        "language" : "text/fhirpath",
                        "expression" : "%patient.contact.where(relationship.coding.exists(code = 'C'))"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-emergencycontact",
                  "text" : "Emergency contact",
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%EmergencyContactArray.name.select((given.join(' ') | family).join(' ') | text)"
                          }
                        }
                      ],
                      "linkId" : "patient-contact-emergencycontact-name",
                      "text" : "Name",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%EmergencyContactArray.telecom.value"
                          }
                        }
                      ],
                      "linkId" : "patient-contact-emergencycontact-phone",
                      "text" : "Phone",
                      "type" : "string",
                      "repeats" : true
                    },
                    {
                      "linkId" : "patient-contact-emergencycontact-relationship",
                      "text" : "Personal relationship to patient (e.g. parent, child, friend)",
                      "type" : "string",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%patient.telecom.where(system = 'phone' and use = 'mobile').value"
                      }
                    }
                  ],
                  "linkId" : "patient-contact-additionalinformation",
                  "text" : "Additional contact information",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "patient-carerdetails",
              "text" : "Carer information",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "patient-carerinformation-hascarer",
                  "text" : "Do you have a carer?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "patient-carerinformation-details",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "patient-carerinformation-hascarer",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "patient-carerinformation-present",
                  "text" : "Carer present at appointment",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "patient-carerinformation-hascarer",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
              "valueCode" : "default-closed"
            }
          ],
          "linkId" : "practitioner",
          "text" : "Practitioner details",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%user.name.where(use='official').select((given.join(' ') | family).join(' ') | text) | %user.name.select((given.join(' ') | family).join(' ') | text)).first()"
                  }
                }
              ],
              "linkId" : "practitioner-name",
              "text" : "Name",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%PractitionerRole.entry.resource.telecom.where(system = 'phone').value"
                  }
                }
              ],
              "linkId" : "practitioner-phone",
              "text" : "Phone",
              "type" : "string",
              "repeats" : true,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%PractitionerRole.entry.resource.telecom.where(system = 'email').value"
                  }
                }
              ],
              "linkId" : "practitioner-email",
              "text" : "Email",
              "type" : "string",
              "repeats" : true,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%PractitionerRole.entry.resource.identifier.where(system = 'http://ns.electronichealth.net.au/id/medicare-provider-number').value"
                  }
                }
              ],
              "linkId" : "practitioner-providernumber",
              "text" : "Provider number",
              "type" : "string",
              "repeats" : true,
              "readOnly" : true
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
              "valueCode" : "default-closed"
            }
          ],
          "linkId" : "clinicalhistory",
          "text" : "Clinical history summary",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
                  "valueCode" : "default-open"
                },
                {
                  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton",
                  "valueBoolean" : true
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "gtable"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "ConditionArray",
                    "language" : "text/fhirpath",
                    "expression" : "%Condition.entry.resource.where(verificationStatus.coding.all(code.empty() or code='confirmed'))"
                  }
                }
              ],
              "linkId" : "clinicalhistory-problemsdiagnoses",
              "text" : "Problems/Diagnoses",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                      "valueQuantity" : {
                        "value" : 40,
                        "system" : "http://unitsofmeasure.org",
                        "code" : "%"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ConditionArray.code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-problemsdiagnoses-condition",
                  "text" : "Condition",
                  "type" : "open-choice",
                  "repeats" : false,
                  "readOnly" : true,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ConditionArray.clinicalStatus.coding"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-problemsdiagnoses-clinicalstatus",
                  "text" : "Clinical status",
                  "type" : "choice",
                  "repeats" : false,
                  "readOnly" : true,
                  "answerValueSet" : "http://hl7.org/fhir/ValueSet/condition-clinical|4.0.1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ConditionArray.onset.ofType(dateTime).toDate()"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-problemsdiagnoses-onsetdate",
                  "text" : "Onset date",
                  "type" : "date",
                  "repeats" : false,
                  "readOnly" : true
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ConditionArray.abatement.ofType(dateTime).toDate()"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-problemsdiagnoses-abatementdate",
                  "text" : "Abatement date",
                  "type" : "date",
                  "repeats" : false,
                  "readOnly" : true
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
                  "valueCode" : "default-open"
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "AllergyIntoleranceArray",
                    "language" : "text/fhirpath",
                    "expression" : "%AllergyIntolerance.entry.resource.where(clinicalStatus.coding.exists(code='active')).where(verificationStatus.coding.all(code.empty() or code='confirmed'))"
                  }
                },
                {
                  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton",
                  "valueBoolean" : true
                }
              ],
              "linkId" : "clinicalhistory-allergy",
              "text" : "Adverse reaction risk summary",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%AllergyIntoleranceArray.code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-allergy-substance",
                  "text" : "Substance",
                  "type" : "open-choice",
                  "repeats" : false,
                  "readOnly" : true,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/adverse-reaction-agent-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%AllergyIntoleranceArray.reaction.manifestation.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-allergy-manifestation",
                  "text" : "Manifestation",
                  "type" : "open-choice",
                  "repeats" : true,
                  "readOnly" : true,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-finding-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%AllergyIntoleranceArray.note[0].text"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-allergy-comment",
                  "text" : "Comment",
                  "type" : "text",
                  "repeats" : false,
                  "readOnly" : true
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
                  "valueCode" : "default-open"
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "MedicationStatementArray",
                    "language" : "text/fhirpath",
                    "expression" : "%MedicationStatement.entry.resource.ofType(MedicationStatement)"
                  }
                },
                {
                  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton",
                  "valueBoolean" : true
                }
              ],
              "linkId" : "clinicalhistory-medications",
              "text" : "Current medications",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%MedicationStatementArray.medication.reference.replace('#', '') in %medicationsFromContained.id, %medicationsFromContained.where(id = %MedicationStatementArray.medication.reference.replace('#', '')).code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first()), iif(%MedicationStatementArray.medication.reference.replace('Medication/', '') in %medicationsFromRef.id , %medicationsFromRef.where(id = %MedicationStatementArray.medication.reference.replace('Medication/', '')).code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first()), %MedicationStatementArray.medication.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())))"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-medications-medication",
                  "text" : "Medication",
                  "type" : "open-choice",
                  "repeats" : false,
                  "readOnly" : true,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-medication-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicationStatementArray.dosage.text"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-medications-dosage",
                  "text" : "Dosage",
                  "type" : "text",
                  "repeats" : false,
                  "readOnly" : true
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicationStatementArray.reasonCode.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-medications-clinicalindication",
                  "text" : "Clinical indication",
                  "type" : "open-choice",
                  "repeats" : true,
                  "readOnly" : true,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/medication-reason-taken-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicationStatementArray.note.text"
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-medications-comment",
                  "text" : "Comment",
                  "type" : "text",
                  "repeats" : false,
                  "readOnly" : true
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
                  "valueCode" : "default-open"
                }
              ],
              "linkId" : "clinicalhistory-observations",
              "text" : "Observations summary",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "grid"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-observations-maingrid",
                  "type" : "group",
                  "repeats" : false,
                  "readOnly" : true,
                  "item" : [
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-height",
                      "text" : "Height",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBodyHeightLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "cm"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-height-value",
                          "text" : "Value",
                          "type" : "decimal",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-maingrid-height-value-unit",
                              "text" : "cm",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBodyHeightLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-height-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-weight",
                      "text" : "Weight",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBodyWeightLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "kg"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-weight-value",
                          "text" : "Value",
                          "type" : "decimal",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-maingrid-weight-value-unit",
                              "text" : "kg",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBodyWeightLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-weight-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-bmi",
                      "text" : "BMI",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                              "valueExpression" : {
                                "description" : "BMI calculation",
                                "language" : "text/fhirpath",
                                "expression" : "(%weight/((%height/100).power(2))).round(1)"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "kg/m2"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-bmi-value",
                          "text" : "Value",
                          "type" : "decimal",
                          "repeats" : false,
                          "readOnly" : true,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-maingrid-bmi-value-unit",
                              "text" : "kg/m2",
                              "type" : "display"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-waistcircumference",
                      "text" : "Waist circumference",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsWaistCircumferenceLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "cm"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-waistcircumference-value",
                          "text" : "Value",
                          "type" : "decimal",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-maingrid-waistcircumference-value-unit",
                              "text" : "cm",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsWaistCircumferenceLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-waistcircumference-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-heartrate",
                      "text" : "Heart rate",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsHeartRateLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "/min"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-heartrate-value",
                          "text" : "Value",
                          "type" : "integer",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-maingrid-heartrate-value-unit",
                              "text" : "/min",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsHeartRateLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-heartrate-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-heartrhythm",
                      "text" : "Heart rhythm",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "drop-down"
                                  }
                                ]
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsHeartRhythmLatest.value.coding.where(system='http://snomed.info/sct').first()"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-heartrhythm-value",
                          "text" : "Value",
                          "type" : "choice",
                          "repeats" : false,
                          "answerOption" : [
                            {
                              "valueCoding" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "933506231000036108",
                                "display" : "Regular heart rhythm"
                              }
                            },
                            {
                              "valueCoding" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "361137007",
                                "display" : "Irregular heart rhythm"
                              }
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsHeartRhythmLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-heartrhythm-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-oxygensaturation",
                      "text" : "Arterial oxygen saturation",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsOxygenSaturationLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-oxygensaturation-value",
                          "text" : "Value",
                          "type" : "integer",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-maingrid-oxygensaturation-value-unit",
                              "text" : "%",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsOxygenSaturationLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-oxygensaturation-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "clinicalhistory-observations-maingrid-smokingstatus",
                      "text" : "Smoking status",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "drop-down"
                                  }
                                ]
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsSmokingStatusLatest.value.coding.where(system='http://snomed.info/sct').first()"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-smokingstatus-value",
                          "text" : "Value",
                          "type" : "choice",
                          "repeats" : false,
                          "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/smoking-status-1"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsSmokingStatusLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-maingrid-smokingstatus-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "grid"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "clinicalhistory-observations-bpgrid",
                  "type" : "group",
                  "repeats" : false,
                  "readOnly" : true,
                  "item" : [
                    {
                      "linkId" : "clinicalhistory-observations-bpgrid-bloodpressure",
                      "text" : "Blood pressure",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8480-6')).value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "mm[Hg]"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-bpgrid-bloodpressure-systolic",
                          "text" : "Systolic",
                          "type" : "integer",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-bpgrid-bloodpressure-systolic-unit",
                              "text" : "mm Hg",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8462-4')).value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "mm[Hg]"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-bpgrid-bloodpressure-diastolic",
                          "text" : "Diastolic",
                          "type" : "integer",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "clinicalhistory-observations-bpgrid-bloodpressure-diastolic-unit",
                              "text" : "mm Hg",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBloodPressureLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "clinicalhistory-observations-bpgrid-bloodpressure-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "linkId" : "plandetails",
          "text" : "Management plan details",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "today()"
                  }
                }
              ],
              "linkId" : "plandetails-commenceddate",
              "text" : "Date this management plan commenced",
              "type" : "date",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%GPCCMPLatest.entry.resource.where(status='in-progress').exists()"
                  }
                }
              ],
              "linkId" : "plandetails-inprogress",
              "text" : "Incomplete draft management plan already exists?",
              "type" : "boolean",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%GPCCMPLatestCompleted.entry.resource.authored"
                  }
                }
              ],
              "linkId" : "plandetails-lastcompleteddate",
              "text" : "Date of last completed management plan",
              "type" : "dateTime",
              "repeats" : false
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
              "valueCode" : "default-open"
            }
          ],
          "linkId" : "plan",
          "text" : "Management plan",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "linkId" : "plan-chronicconditiondetails",
              "text" : "Chronic condition details",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "plan-chronicconditiondetails-condition",
                  "text" : "Condition",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1"
                },
                {
                  "linkId" : "plan-chronicconditiondetails-onsetdate",
                  "text" : "Onset date",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "linkId" : "plan-chronicconditiondetails-comments",
                  "text" : "Comments",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
                  "valueCode" : "default-open"
                }
              ],
              "linkId" : "plan-planitems",
              "text" : "Plan items",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "plan-planitems-problemneed",
                  "text" : "Problem/Need",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1"
                },
                {
                  "linkId" : "plan-planitems-details",
                  "text" : "Details",
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "gtable"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "plan-planitems-details-goalsetting",
                      "text" : "Goal setting",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                            "valueBoolean" : true
                          }
                        ]
                      },
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 70,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-goalsetting-goals",
                          "text" : "Goals",
                          "type" : "text",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 30,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-goalsetting-targetdate",
                          "text" : "Target date",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "gtable"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "plan-planitems-details-interventionsactions",
                      "text" : "Interventions and actions",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                            "valueBoolean" : true
                          }
                        ]
                      },
                      "type" : "group",
                      "repeats" : true,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 28,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "autocomplete"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-interventionsactions-interventionsactions",
                          "text" : "Interventions/Actions",
                          "type" : "open-choice",
                          "repeats" : false,
                          "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/procedure-1"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 24,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-interventionsactions-owner",
                          "text" : "Owner",
                          "type" : "string",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 17,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-interventionsactions-duedate",
                          "text" : "Due date",
                          "type" : "date",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 31,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-interventionsactions-comment",
                          "text" : "Comment",
                          "type" : "string",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "gtable"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "plan-planitems-details-servicestreatments",
                      "text" : "Services and treatments",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                            "valueBoolean" : true
                          }
                        ]
                      },
                      "type" : "group",
                      "repeats" : true,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 23,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "autocomplete"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-servicestreatments-servicestreatments",
                          "text" : "Required services and treatments",
                          "type" : "open-choice",
                          "repeats" : false,
                          "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/service-type-1"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 23,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "autocomplete"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-servicestreatments-activity",
                          "text" : "Activity",
                          "type" : "open-choice",
                          "repeats" : false,
                          "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/procedure-1"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 23,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-servicestreatments-provider",
                          "text" : "Provider",
                          "type" : "string",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                              "valueQuantity" : {
                                "value" : 31,
                                "system" : "http://unitsofmeasure.org",
                                "code" : "%"
                              }
                            }
                          ],
                          "linkId" : "plan-planitems-details-servicestreatments-comment",
                          "text" : "Comment",
                          "type" : "string",
                          "repeats" : false
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "linkId" : "notes",
          "text" : "Notes",
          "type" : "group",
          "item" : [
            {
              "linkId" : "notes-additionalcomments",
              "text" : "Additional notes or comments",
              "type" : "text",
              "repeats" : true
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-collapsible",
              "valueCode" : "default-open"
            }
          ],
          "linkId" : "finalpreparations",
          "text" : "Final preparations of management plan",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "linkId" : "finalpreparations-consent",
              "text" : "Consent",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "finalpreparations-consent-sharingconsent",
                  "text" : "Consent given for sharing of information with relevant healthcare providers",
                  "type" : "boolean",
                  "repeats" : false
                },
                {
                  "linkId" : "finalpreparations-consent-planconsent",
                  "text" : "Consent given to proceed with plan after discussion of the purpose, benefits, process and costs",
                  "type" : "boolean",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "finalpreparations-review",
              "text" : "Scheduled review date",
              "type" : "date",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "finalpreparations-copyoffered",
              "text" : "Patient has been offered a copy of this plan",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Yes, copy provided"
                },
                {
                  "valueString" : "Yes, copy to be posted"
                },
                {
                  "valueString" : "Yes, but declined"
                },
                {
                  "valueString" : "Not offered. Plan to follow up and offer at a later date"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
