# GPCCMP Server Capability Statement - GP Chronic Condition Management Plan v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GPCCMP Server Capability Statement**

## CapabilityStatement: GPCCMP Server Capability Statement 

| | |
| :--- | :--- |
| *Official URL*:https://gpccmp.csiro.au/ig/CapabilityStatement/GPCCMPServerCapabilityStatement | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:GPCCMPServerCapabilityStatement |

 
This CapabilityStatement describes the expected capabilities for systems to exchange the data needed to support the [GP Chronic Condition Management Plan](Questionnaire-GPChronicConditionManagementPlan.md). It lists the server's conformance expectations for the resource types required as Questionnaire launch context, resource types required to support prepopulation of the form and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters. 

 [Raw OpenAPI-Swagger Definition file](GPCCMPServerCapabilityStatement.openapi.json) | [Download](GPCCMPServerCapabilityStatement.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "GPCCMPServerCapabilityStatement",
  "url" : "https://gpccmp.csiro.au/ig/CapabilityStatement/GPCCMPServerCapabilityStatement",
  "version" : "0.1.0",
  "name" : "GPCCMPServerCapabilityStatement",
  "title" : "GPCCMP Server Capability Statement",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the expected capabilities for systems to exchange the data needed to support the [GP Chronic Condition Management Plan](Questionnaire-GPChronicConditionManagementPlan.html). It lists the server's conformance expectations for the resource types required as Questionnaire launch context, resource types required to support prepopulation of the form and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters.",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "GPCCMP Launch Server **SHALL**:\n1. Support the [AU Core AllergyIntolerance resource profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-allergyintolerance.html)\n1. Support the [AU Core Condition resource profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-condition.html)\n1. Support the [AU Core Encounter resource profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-encounter.html)\n1. Support the [AU Core Medication profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-medication.html)\n1. Support the [AU Core MedicationStatement profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-medicationstatement.html)\n1. Support the [AU Core Patient resource profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-patient.html)\n1. Support the [AU Core Practitioner resource profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-practitioner.html)\n1. Support the [AU Core PractitionerRole resource profile](https://hl7.org.au/fhir/core/2.0.0-preview/StructureDefinition-au-core-practitionerrole.html)\n1. Support the [SDC Standard Questionnaire Response resource profile](https://build.fhir.org/ig/HL7/sdc/en/StructureDefinition-sdc-questionnaireresponse.html)\n1. Implement the RESTful behavior according to the FHIR specification\n1. Support JSON source formats for all interactions",
      "security" : {
        "cors" : true,
        "_cors" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ]
        },
        "service" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "MAY"
              }
            ],
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "GPCCMP Launch Server **MAY**:\n1. Support CORS headers\n1. Support SMART on FHIR security services\n\nAlso see the [AU Core Security and Privacy](https://hl7.org.au/fhir/core/2.0.0-preview/security.html) section for general considerations and recommendations."
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AllergyIntolerance",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the AllergyIntolerance resource, the AU Core profile and the conformance expectations for the AllergyIntolerance resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "category"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Condition",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Condition resource, the AU Core profile and the conformance expectations for the Condition resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-category",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \n\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Encounter",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **MAY** support the Encounter resource. If it does, it **SHALL** support the AU Core profile and the conformance expectations for the Encounter resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Medication",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medication"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If an external reference to a Medication resource is used in MedicationStatement, then the server **SHALL** support the Medication resource, the AU Core profile and the conformance expectations for the Medication resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                },
                {
                  "url" : "required",
                  "valueString" : "_include"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "MedicationStatement",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the MedicationStatement resource, the AU Core profile and the conformance expectations for the MedicationStatement resource.\n\nIf a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`)\n",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : ["MedicationStatement:medication"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/medications-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values.\n\nThe server **SHALL** support both.\n\nThe client **SHALL** support `multipleOr`.\n\nThe server **SHALL** support `multipleOr`."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_include",
              "type" : "reference",
              "documentation" : "If a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`).\n\nThe client **SHALL** support this method."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Patient resource, AU Core profile and the conformance expectations for the Patient resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Practitioner",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Practitioner resource, AU Core profile and the conformance expectations for the Practitioner resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "questionnaire"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "QuestionnaireResponse",
          "supportedProfile" : [
            "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the QuestionnaireResponse resource, SDC profile and the conformance expectations for the QuestionnaireResponse resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "versioning" : "versioned-update",
          "_versioning" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both. "
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "questionnaire",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-questionnaire",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both.\n\nThe client and server **SHALL** support chained search questionnaire.title using the :contains modifier."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \n\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_count",
              "type" : "number",
              "documentation" : "The client and server **SHALL** support search result limiting."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by authored and **MAY** support other values."
            }
          ]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "code" : "transaction",
          "documentation" : "The server **SHALL** support the transaction interaction for all resources."
        }
      ]
    }
  ]
}

```
