# Artifacts Summary - GP Chronic Condition Management Plan v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [GPCCMP Client](ActorDefinition-GPCCMPClient.md) | The GPCCMP Client is a system that can display the GPCCPM form, prepopulate it with patient health information retrieved from the GPCCMP Server, allow a user to fill out the form and save the form to the GPCCMP Server. |
| [GPCCMP Server](ActorDefinition-GPCCMPServer.md) | The GPCCMP Server allows the GPCCMP Client to retrieve patient health information and writeback completed or partially completed forms. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [GPCCMP Client Capability Statement](CapabilityStatement-GPCCMPClientCapabilityStatement.md) | This CapabilityStatement describes the expected capabilities for systems to exchange the data needed to support the [GP Chronic Condition Management Plan](Questionnaire-GPChronicConditionManagementPlan.md). It lists the client's conformance expectations for the resource types required as Questionnaire launch context, resource types required to support prepopulation of the form and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters. |
| [GPCCMP Server Capability Statement](CapabilityStatement-GPCCMPServerCapabilityStatement.md) | This CapabilityStatement describes the expected capabilities for systems to exchange the data needed to support the [GP Chronic Condition Management Plan](Questionnaire-GPChronicConditionManagementPlan.md). It lists the server's conformance expectations for the resource types required as Questionnaire launch context, resource types required to support prepopulation of the form and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters. |

### Structures: Questionnaires 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| | |
| :--- | :--- |
| [GP Chronic Condition Management Plan](Questionnaire-GPChronicConditionManagementPlan.md) | GP Chronic Condition Management Plan |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [GP CCMP Questionnaire Response](StructureDefinition-GPCCMPQuestionnaireResponse.md) | This profile sets the minimum expectations for a QuestionnaireResponse resource to record, search and save GP Chronic Condition Management Plan information. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Group Hide Add Item Button](StructureDefinition-GroupHideAddItemButton.md) | This custom extension is used to hide the UI component that allows a user to add new items for repeating groups in a Questionnaire. This is useful for preventing users from adding additional groups when it is not appropriate to do so, such as when a group is intended to be prepopulated with existing data but no new ones added by the user. |
| [Questionnaire Item Text Hidden](StructureDefinition-QuestionnaireItemTextHidden.md) | This custom extension is used to indicate that the text of a Questionnaire item should be hidden in the user interface. This is useful for items where the text is not intended to be displayed to the user but is still needed for other processes. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Yes/No/NA](ValueSet-YesNoNA.md) | Concepts for Yes, No and Not applicable |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Launch Context Extension](CodeSystem-LaunchContextExtended.md) | The Launch Context Extension code system defines concepts that extend the HL7 launch context concepts in http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext. They enable additional launch context items to be specified for use when launching a GP CCMP Questionnaire. |

