# Launch Context Extension - GP Chronic Condition Management Plan v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Launch Context Extension**

## CodeSystem: Launch Context Extension 

| | |
| :--- | :--- |
| *Official URL*:https://gpccmp.csiro.au/ig/CodeSystem/LaunchContextExtended | *Version*:0.1.0 |
| Draft as of 2026-01-28 | *Computable Name*:LaunchContextExtended |

 
The Launch Context Extension code system defines concepts that extend the HL7 launch context concepts in http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext. They enable additional launch context items to be specified for use when launching a GP CCMP Questionnaire. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "LaunchContextExtended",
  "url" : "https://gpccmp.csiro.au/ig/CodeSystem/LaunchContextExtended",
  "version" : "0.1.0",
  "name" : "LaunchContextExtended",
  "title" : "Launch Context Extension",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-28T04:53:48+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        }
      ]
    }
  ],
  "description" : "The Launch Context Extension code system defines concepts that extend the HL7 launch context concepts in http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext. They enable additional launch context items to be specified for use when launching a GP CCMP Questionnaire.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 1,
  "concept" : [
    {
      "code" : "gpccmppractitionerrole",
      "display" : "GP CCMP Practitioner Role",
      "definition" : "PractitionerRole in context at launch time that is associated with the user in context. This concept has been defined to support use cases where the PractitionerRole is required to pre-populate the GP CCMP Questionnaire."
    }
  ]
}

```
