# idmp.who-umc.org.fhir#0.1.0: UMC IDMP Request and Publish API

## Pages

* [](index.md)
* [IG change history](changes.md)
* [PhPID (AdministrableProductDefinition) request](phpIdRequest.md)
* [Operating model](operatingModel.md)
* [Profiles](profiles.md)
* [Versioning](versioning.md)
* [Useful downloads](downloads.md)
* [Publishing](publishing.md)
* [Authentication](authentication.md)
* [Background](background.md)
* [Change management](subscription.md)
* [Artifacts Summary](artifacts.md)
* [Terminologies](terminologies.md)

## Resources

### CodeSystems

* [WHODrug DrugCode](CodeSystem-drugcode.md)
* [EDQM dose form attributes](CodeSystem-edqmDoseFormAttributes.md)
* [Additional jurisdictional areas compolementing the ISO 3166 country codes](CodeSystem-jurisdiction.md)
* [Pdf Characteristics](CodeSystem-pdfCharacteristics.md)
* [PhPId level](CodeSystem-php-level.md)
* [Strength units applicable in the IDMP PhPID service](CodeSystem-strengthUnit.md)
* [Task input type](CodeSystem-task-input-type.md)
* [Task output type](CodeSystem-task-output-type.md)
* [Task request code](CodeSystem-task-request-code.md)

### ValueSets

* [WHO ATC](ValueSet-atcClassification.md)
* [Channel Type Value Set](ValueSet-channelType.md)
* [EDQM PDF characteristics: Administration Method](ValueSet-edqm-AME.md)
* [EDQM PDF characteristics: Basic Dose Form](ValueSet-edqm-BDF.md)
* [EDQM PDF characteristics: Intended Site](ValueSet-edqm-ISI.md)
* [EDQM PDF characteristics: Release Characteristics](ValueSet-edqm-RCA.md)
* [GSID request input type value set](ValueSet-gsid-task-input-type.md)
* [GSID request output type value set](ValueSet-gsid-task-output-type.md)
* [Jurisdiction Value Set](ValueSet-jurisdiction.md)
* [MPID system](ValueSet-mpid-system.md)
* [EDQM Pharmaceutical Form](ValueSet-pharmaceuticalForm.md)
* [PhPID request input type value set](ValueSet-phpid-task-input-type.md)
* [PhPID request output type value set](ValueSet-phpid-task-output-type.md)
* [Identifier Type Value Set](ValueSet-phpid-type.md)
* [Request Status Value Set](ValueSet-requestStatus.md)
* [Route Of Administration](ValueSet-routeOfAdministration.md)
* [Strength Unit Value Set](ValueSet-strengthUnit.md)

### Resource Profiles

* [AdministrableProductDefinition (WHO PhP)](StructureDefinition-AdministrableProductDefinition-who-php.md)
* [Organization authorized to use the WHO-UMC IDMP service](StructureDefinition-AuthorizedOrg-who-php.md)
* [Ingredient (WHO PhP publish)](StructureDefinition-Ingredient-who-php-publish.md)
* [Ingredient (WHO PhP)](StructureDefinition-Ingredient-who-php.md)
* [Marketing Authorization Holder](StructureDefinition-MarketingAuthorizationHolder-who-php.md)
* [MedicinalProductDefinition for publication](StructureDefinition-MedicinalProductDefinition-who-php-pub.md)
* [MedicinalProductDefinition for PhPID request](StructureDefinition-MedicinalProductDefinition-who-php-req.md)
* [Regulated Authorization](StructureDefinition-RegulatedAuthorization-who-php.md)
* [Subscription for event notifications](StructureDefinition-Subscription-IdmpEvent.md)
* [SubstanceDefinition for publication](StructureDefinition-SubstanceDefinition-pub.md)
* [Task PhPID request status](StructureDefinition-Task-who-php-phpid-status.md)
* [Task PhPID request](StructureDefinition-Task-who-php-phpid.md)

### Extensions

* [Pharmaceutical dose form - AdministrationMethod](StructureDefinition-administration-method.md)
* [Pharmaceutical dose form - BasicDoseForm](StructureDefinition-basic-dose-form.md)
* [Pharmaceutical dose form - IntendedSite](StructureDefinition-intended-site.md)
* [Parent PhP](StructureDefinition-parent-phpid.md)
* [Pharmaceutical dose form - ReleaseCharacteristics](StructureDefinition-release-characteristics.md)

### CapabilityStatements

* [API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs](CapabilityStatement-UMC-IDMP-API.md)

### ImplementationGuides

* [UMC IDMP Request and Publish API](index.md)

### SearchParameters

* [Parent PhPID](SearchParameter-parent-php.md)

### Examples

* [6C4563BB76BE7967594979196EC91CD8 (AdministrableProductDefinition)](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md)
* [8195D4AF1287CCE3442C2F308F61DBBC (AdministrableProductDefinition)](AdministrableProductDefinition-8195D4AF1287CCE3442C2F308F61DBBC.md)
* [91B3CA582581F57E4092F13AAF476215 (AdministrableProductDefinition)](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md)
* [93FE88350C2E8868F7E8BD220C4E0010 (AdministrableProductDefinition)](AdministrableProductDefinition-93FE88350C2E8868F7E8BD220C4E0010.md)
* [1266520E021 (MedicinalProductDefinition)](MedicinalProductDefinition-1266520E021.md)
* [1A0661AE2A40 (MedicinalProductDefinition)](MedicinalProductDefinition-1A0661AE2A40.md)
* [Demo end point (Subscription)](Subscription-template-generated-by-server-subscription-email.md)
* [Demo end point (Subscription)](Subscription-template-generated-by-server-subscription-rest-hook.md)
* [Administrable Product Definition Event (SubscriptionTopic)](SubscriptionTopic-admProdDef.md)
* [GSID23G92UMX93H45 (SubstanceDefinition)](SubstanceDefinition-GSID23G92UMX93H45.md)
* [GSID85RFP2XGF3X29 (SubstanceDefinition)](SubstanceDefinition-GSID85RFP2XGF3X29.md)
* [GSID9XBS2KCF3K1Z1 (SubstanceDefinition)](SubstanceDefinition-GSID9XBS2KCF3K1Z1.md)
* [task-completed-phpid (Task)](Task-task-completed-phpid.md)
* [template-generated-by-server-phpid-req (Task)](Task-template-generated-by-server-phpid-req.md)
