# UMC IDMP Request and Publish API - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **UMC IDMP Request and Publish API**

## UMC IDMP Request and Publish API

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ImplementationGuide/idmp.who-umc.org.fhir | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:UmcIDMPManagement |

### Scope

The scope of this Implementation Guide is to document the UMC IDMP API FHIR service, by describing the context in which the API can be used as well as the technical overview for using the API.

### Introduction

This Implementation Guide has a target audience of system integrators to the UMC IDMP API. The API is based on the HL7 FHIR standard and this guide describes supported FHIR resources.

The Implementation Guide describes how FHIR standard is used to exchange data for ISO IDMP standards for global PhPIDs and GSIDs. For information about ISO IDMP, see the [Background](background.md) section in this guide.

The main resources maintained by the service are the Pharmaceutical Product IDs, PhPIDs, (manifested through the AdministrableProductDefinition resource) and the Global Substance IDs, GSIDs, (manifested through the SubstanceDefinition resource). However, the MedicinalProductDefinition resource is also vital since it serves as input for PhPID generation. The Implementation Guide describes how new global PhPIDs are requested using asynchronous FHIR requests, and how they are delivered through FHIR.

#### Access to the UMC IDMP FHIR server

##### Production

The production FHIR server can be reached at [https://idmp.who-umc.org/fhir](https://idmp.who-umc.org/fhir). To get access to the production server, please contact asa.parnaste [at] who-umc.org.

##### Preview

The preview FHIR server can be reached at [https://preview-idmp.who-umc.org/fhir](https://preview-idmp.who-umc.org/fhir). To get access to the preview server, please contact asa.parnaste [at] who-umc.org.

##### Proof of Concept

The PoC FHIR server can be reached at [https://api.umcterminologies.org/idmp](https://api.umcterminologies/idmp). A tutorial with examples is found at [https://api.umcterminologies.org/](https://api.umcterminologies.org/)

### Dependencies



### Cross Version Analysis

### Global Profiles

*There are no Global profiles defined*

### IP statements

This publication includes IP covered under the following statements.

* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* SNOMED Clinical Terms&reg; (SNOMED CT&reg;): [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md) and [VsRouteOfAdministration](ValueSet-routeOfAdministration.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Organization type](http://terminology.hl7.org/7.0.0/CodeSystem-organization-type.html): [Task/task-completed-phpid](Task-task-completed-phpid.md) and [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md)
* [SubscriptionChannel Type Codes](http://terminology.hl7.org/7.0.0/CodeSystem-subscription-channel-type.html): [Demo end point](Subscription-template-generated-by-server-subscription-rest-hook.md), [SubscriptionIdmpEvent](StructureDefinition-Subscription-IdmpEvent.md) and [channelType](ValueSet-channelType.md)


* Unless otherwise indicated, reproduction of material posted on Council of Europe websites, and reproduction of photographs for which the Council of Europe holds copyright – see legal notice \“photo credits\” – is authorised for private use and for informational and educational uses relating to the Council of Europe’s work. This authorisation is subject to the condition that the source be indicated and no charge made for reproduction. Persons wishing to make some other use than those specified above, including commercial use, of information and text posted on these sites are asked to apply for prior written authorisation to the Council of Europe, Directorate of Communication.

* [EDQM Standard Terms](http://tx.fhir.org/r5/ValueSet/edqm): [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md) and [pharmaceuticalForm](ValueSet-pharmaceuticalForm.md)


* Uppsala Monitoring Centre

* [WHODrug DrugCode](CodeSystem-drugcode.md): [MedicinalProductDefinition/1266520E021](MedicinalProductDefinition-1266520E021.md) and [MedicinalProductDefinition/1A0661AE2A40](MedicinalProductDefinition-1A0661AE2A40.md)
* [EDQM dose form attributes](CodeSystem-edqmDoseFormAttributes.md): [AME](StructureDefinition-administration-method.md), [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md)...Show 8 more,[AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md),[BDF](StructureDefinition-basic-dose-form.md),[ISI](StructureDefinition-intended-site.md),[RCA](StructureDefinition-release-characteristics.md),[edqm-AME](ValueSet-edqm-AME.md),[edqm-BDF](ValueSet-edqm-BDF.md),[edqm-ISI](ValueSet-edqm-ISI.md)and[edqm-RCA](ValueSet-edqm-RCA.md)
* [Additional jurisdictional areas compolementing the ISO 3166 country codes](CodeSystem-jurisdiction.md): [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md), [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md) and [VsJurisdiction](ValueSet-jurisdiction.md)
* [PhPId level](CodeSystem-php-level.md): [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md), [AdministrableProductDefinition/8195D4AF1287CCE3442C2F308F61DBBC](AdministrableProductDefinition-8195D4AF1287CCE3442C2F308F61DBBC.md)...Show 5 more,[AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md),[AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010](AdministrableProductDefinition-93FE88350C2E8868F7E8BD220C4E0010.md),[AdministrableProductDefinitionWhoPhP](StructureDefinition-AdministrableProductDefinition-who-php.md),[Task/task-completed-phpid](Task-task-completed-phpid.md)and[VsPhpIdLevels](ValueSet-phpid-type.md)
* [Strength units applicable in the IDMP PhPID service](CodeSystem-strengthUnit.md): [IngredientWhoPhPPublish](StructureDefinition-Ingredient-who-php-publish.md), [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md) and [VsStrengthUnit](ValueSet-strengthUnit.md)
* [Task input type](CodeSystem-task-input-type.md): [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md)...Show 4 more,[TaskGeneratePhPID](StructureDefinition-Task-who-php-phpid.md),[TaskGeneratePhPIDStatus](StructureDefinition-Task-who-php-phpid-status.md),[VsGSIDTaskInputTypes](ValueSet-gsid-task-input-type.md)and[VsPhPIDTaskInputTypes](ValueSet-phpid-task-input-type.md)
* [Task output type](CodeSystem-task-output-type.md): [Task/task-completed-phpid](Task-task-completed-phpid.md), [TaskGeneratePhPIDStatus](StructureDefinition-Task-who-php-phpid-status.md), [VsGSIDTaskOutputTypes](ValueSet-gsid-task-output-type.md) and [VsPhPIDTaskOutputTypes](ValueSet-phpid-task-output-type.md)
* [Task request code](CodeSystem-task-request-code.md): [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md), [TaskGeneratePhPID](StructureDefinition-Task-who-php-phpid.md) and [TaskGeneratePhPIDStatus](StructureDefinition-Task-who-php-phpid-status.md)


* WHO Collaborating Centre for Drug Statistics Methodology, Oslo, Norway. Use of all or parts of the material requires reference to the WHO Collaborating Centre for Drug Statistics Methodology. Copying and distribution for commercial purposes is not allowed. Changing or manipulating the material is not allowed.

* [ATC classification system](http://tx.fhir.org/r5/ValueSet/atc): [MedicinalProductDefinition/1266520E021](MedicinalProductDefinition-1266520E021.md), [MedicinalProductDefinition/1A0661AE2A40](MedicinalProductDefinition-1A0661AE2A40.md), [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md) and [VsAtcClassification](ValueSet-atcClassification.md)


### Authors and Contributors

| | | | |
| :--- | :--- | :--- | :--- |
| Author | Magnus Wallberg | Uppsala Monitoring Centre | magnus.wallberg [at] who-umc.org |
| Author | Giorgio Cangioli | HL7 Europe | giorgio.cangioli [at] gmail.com |
| Author | Åsa Pärnaste | Uppsala Monitoring Centre | asa.parnaste [at] who-umc.org |
| Author | João Almeida | HL7 Europe | joaofilipe90 [at] gmail.com |
| Author | Mikael Nilsson | Uppsala Monitoring Centre | mikael.nilsson [at] who-umc.org |

