# EDQM Pharmaceutical Form - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EDQM Pharmaceutical Form**

## ValueSet: EDQM Pharmaceutical Form 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ValueSet/pharmaceuticalForm | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:pharmaceuticalForm |

 
EDQM Pharmaceutical Forms 

 **References** 

* [MedicinalProductDefinition for publication](StructureDefinition-MedicinalProductDefinition-who-php-pub.md)
* [MedicinalProductDefinition for PhPID request](StructureDefinition-MedicinalProductDefinition-who-php-req.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "pharmaceuticalForm",
  "url" : "http://who-umc.org/idmp/ValueSet/pharmaceuticalForm",
  "version" : "0.1.0",
  "name" : "pharmaceuticalForm",
  "title" : "EDQM Pharmaceutical Form",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "EDQM Pharmaceutical Forms",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://standardterms.edqm.eu",
        "concept" : [
          {
            "code" : "12102000",
            "display" : "Anticoagulant and preservative solution for blood"
          },
          {
            "code" : "10501000",
            "display" : "Bath additive"
          },
          {
            "code" : "11502000",
            "display" : "Bladder irrigation"
          },
          {
            "code" : "10314011",
            "display" : "Buccal film"
          },
          {
            "code" : "10320000",
            "display" : "Buccal tablet"
          },
          {
            "code" : "10209000",
            "display" : "Cachet"
          },
          {
            "code" : "10210000",
            "display" : "Capsule, hard"
          },
          {
            "code" : "10211000",
            "display" : "Capsule, soft"
          },
          {
            "code" : "10214000",
            "display" : "Chewable capsule, soft"
          },
          {
            "code" : "10228000",
            "display" : "Chewable tablet"
          },
          {
            "code" : "50001000",
            "display" : "Chewable/dispersible tablet"
          },
          {
            "code" : "13046000",
            "display" : "Coated granules"
          },
          {
            "code" : "10220000",
            "display" : "Coated tablet"
          },
          {
            "code" : "10520000",
            "display" : "Collodion"
          },
          {
            "code" : "10322000",
            "display" : "Compressed lozenge"
          },
          {
            "code" : "13001000",
            "display" : "Concentrate for concentrate for solution for infusion"
          },
          {
            "code" : "13162000",
            "display" : "Concentrate for cutaneous emulsion"
          },
          {
            "code" : "10514000",
            "display" : "Concentrate for cutaneous solution"
          },
          {
            "code" : "50009000",
            "display" : "Concentrate for cutaneous spray, emulsion"
          },
          {
            "code" : "50009300",
            "display" : "Concentrate for dispersion for infusion"
          },
          {
            "code" : "13139000",
            "display" : "Concentrate for dispersion for injection"
          },
          {
            "code" : "50009500",
            "display" : "Concentrate for emulsion for infusion"
          },
          {
            "code" : "13152000",
            "display" : "Concentrate for emulsion for injection"
          },
          {
            "code" : "10302000",
            "display" : "Concentrate for gargle"
          },
          {
            "code" : "50009750",
            "display" : "Concentrate for intravesical solution"
          },
          {
            "code" : "13002000",
            "display" : "Concentrate for nebuliser solution"
          },
          {
            "code" : "50010000",
            "display" : "Concentrate for oral solution"
          },
          {
            "code" : "10100500",
            "display" : "Concentrate for oral suspension"
          },
          {
            "code" : "50011000",
            "display" : "Concentrate for oral/rectal solution"
          },
          {
            "code" : "13003000",
            "display" : "Concentrate for oromucosal solution"
          },
          {
            "code" : "11008000",
            "display" : "Concentrate for rectal solution"
          },
          {
            "code" : "11405000",
            "display" : "Concentrate for solution for haemodialysis"
          },
          {
            "code" : "11213000",
            "display" : "Concentrate for solution for infusion"
          },
          {
            "code" : "11209000",
            "display" : "Concentrate for solution for injection"
          },
          {
            "code" : "50079000",
            "display" : "Concentrate for solution for injection/infusion"
          },
          {
            "code" : "10600500",
            "display" : "Concentrate for solution for intraocular irrigation"
          },
          {
            "code" : "50013250",
            "display" : "Concentrate for solution for peritoneal dialysis"
          },
          {
            "code" : "13004000",
            "display" : "Concentrate for suspension for injection"
          },
          {
            "code" : "10502000",
            "display" : "Cream"
          },
          {
            "code" : "10516000",
            "display" : "Cutaneous emulsion"
          },
          {
            "code" : "10507000",
            "display" : "Cutaneous foam"
          },
          {
            "code" : "10512000",
            "display" : "Cutaneous liquid"
          },
          {
            "code" : "10505000",
            "display" : "Cutaneous paste"
          },
          {
            "code" : "10517500",
            "display" : "Cutaneous patch"
          },
          {
            "code" : "10517000",
            "display" : "Cutaneous powder"
          },
          {
            "code" : "10513000",
            "display" : "Cutaneous solution"
          },
          {
            "code" : "50015450",
            "display" : "Cutaneous solution/concentrate for oromucosal solution"
          },
          {
            "code" : "50015500",
            "display" : "Cutaneous spray, emulsion"
          },
          {
            "code" : "50016000",
            "display" : "Cutaneous spray, ointment"
          },
          {
            "code" : "10511000",
            "display" : "Cutaneous spray, powder"
          },
          {
            "code" : "10509000",
            "display" : "Cutaneous spray, solution"
          },
          {
            "code" : "10510000",
            "display" : "Cutaneous spray, suspension"
          },
          {
            "code" : "10523000",
            "display" : "Cutaneous stick"
          },
          {
            "code" : "10515000",
            "display" : "Cutaneous suspension"
          },
          {
            "code" : "50015200",
            "display" : "Cutaneous/nasal ointment"
          },
          {
            "code" : "13140000",
            "display" : "Cutaneous/oromucosal solution"
          },
          {
            "code" : "10401500",
            "display" : "Dental cement"
          },
          {
            "code" : "10408000",
            "display" : "Dental emulsion"
          },
          {
            "code" : "10402000",
            "display" : "Dental gel"
          },
          {
            "code" : "50017000",
            "display" : "Dental paste"
          },
          {
            "code" : "10405000",
            "display" : "Dental powder"
          },
          {
            "code" : "10406000",
            "display" : "Dental solution"
          },
          {
            "code" : "10403000",
            "display" : "Dental stick"
          },
          {
            "code" : "10407000",
            "display" : "Dental suspension"
          },
          {
            "code" : "12101000",
            "display" : "Denture lacquer"
          },
          {
            "code" : "10121000",
            "display" : "Dispersible tablet"
          },
          {
            "code" : "10121500",
            "display" : "Dispersible tablets for dose dispenser"
          },
          {
            "code" : "13005000",
            "display" : "Dispersion for concentrate for dispersion for infusion"
          },
          {
            "code" : "50017500",
            "display" : "Dispersion for infusion"
          },
          {
            "code" : "50077000",
            "display" : "Dispersion for injection"
          },
          {
            "code" : "13049000",
            "display" : "Dispersion for injection/infusion"
          },
          {
            "code" : "10701000",
            "display" : "Ear cream"
          },
          {
            "code" : "10706000",
            "display" : "Ear drops, emulsion"
          },
          {
            "code" : "13006000",
            "display" : "Ear drops, powder for suspension"
          },
          {
            "code" : "10704000",
            "display" : "Ear drops, solution"
          },
          {
            "code" : "10705000",
            "display" : "Ear drops, suspension"
          },
          {
            "code" : "10702000",
            "display" : "Ear gel"
          },
          {
            "code" : "10703000",
            "display" : "Ear ointment"
          },
          {
            "code" : "10708000",
            "display" : "Ear powder"
          },
          {
            "code" : "10711000",
            "display" : "Ear spray, emulsion"
          },
          {
            "code" : "10709000",
            "display" : "Ear spray, solution"
          },
          {
            "code" : "10710000",
            "display" : "Ear spray, suspension"
          },
          {
            "code" : "10715000",
            "display" : "Ear stick"
          },
          {
            "code" : "10714000",
            "display" : "Ear tampon"
          },
          {
            "code" : "10713000",
            "display" : "Ear wash, emulsion"
          },
          {
            "code" : "10712000",
            "display" : "Ear wash, solution"
          },
          {
            "code" : "50018000",
            "display" : "Ear/eye drops, solution"
          },
          {
            "code" : "50018500",
            "display" : "Ear/eye drops, suspension"
          },
          {
            "code" : "50019000",
            "display" : "Ear/eye ointment"
          },
          {
            "code" : "50019500",
            "display" : "Ear/eye/nasal drops, solution"
          },
          {
            "code" : "50020200",
            "display" : "Ear/nasal drops, suspension"
          },
          {
            "code" : "10205000",
            "display" : "Effervescent granules"
          },
          {
            "code" : "13007000",
            "display" : "Effervescent granules for oral suspension"
          },
          {
            "code" : "10203000",
            "display" : "Effervescent powder"
          },
          {
            "code" : "10222000",
            "display" : "Effervescent tablet"
          },
          {
            "code" : "10913000",
            "display" : "Effervescent vaginal tablet"
          },
          {
            "code" : "13008000",
            "display" : "Emulsion for emulsion for injection"
          },
          {
            "code" : "11211000",
            "display" : "Emulsion for infusion"
          },
          {
            "code" : "11203000",
            "display" : "Emulsion for injection"
          },
          {
            "code" : "50021000",
            "display" : "Emulsion for injection/infusion"
          },
          {
            "code" : "13091000",
            "display" : "Emulsion for suspension for injection"
          },
          {
            "code" : "11701000",
            "display" : "Endocervical gel"
          },
          {
            "code" : "13041000",
            "display" : "Endosinusial solution"
          },
          {
            "code" : "50022000",
            "display" : "Endosinusial wash, suspension"
          },
          {
            "code" : "11602000",
            "display" : "Endotracheopulmonary instillation, powder for solution"
          },
          {
            "code" : "13009000",
            "display" : "Endotracheopulmonary instillation, powder for suspension"
          },
          {
            "code" : "11601000",
            "display" : "Endotracheopulmonary instillation, solution"
          },
          {
            "code" : "11603000",
            "display" : "Endotracheopulmonary instillation, suspension"
          },
          {
            "code" : "13042000",
            "display" : "Epilesional solution"
          },
          {
            "code" : "10601000",
            "display" : "Eye cream"
          },
          {
            "code" : "10604500",
            "display" : "Eye drops, emulsion"
          },
          {
            "code" : "13010000",
            "display" : "Eye drops, powder for solution"
          },
          {
            "code" : "13011000",
            "display" : "Eye drops, powder for suspension"
          },
          {
            "code" : "13159000",
            "display" : "Eye drops, prolonged-release solution"
          },
          {
            "code" : "10604000",
            "display" : "Eye drops, solution"
          },
          {
            "code" : "10608000",
            "display" : "Eye drops, solvent for reconstitution"
          },
          {
            "code" : "10605000",
            "display" : "Eye drops, suspension"
          },
          {
            "code" : "10602000",
            "display" : "Eye gel"
          },
          {
            "code" : "10610000",
            "display" : "Eye lotion"
          },
          {
            "code" : "10611000",
            "display" : "Eye lotion, solvent for reconstitution"
          },
          {
            "code" : "10603000",
            "display" : "Eye ointment"
          },
          {
            "code" : "13154000",
            "display" : "Film-coated granules"
          },
          {
            "code" : "10221000",
            "display" : "Film-coated tablet"
          },
          {
            "code" : "10301000",
            "display" : "Gargle"
          },
          {
            "code" : "10303000",
            "display" : "Gargle, powder for solution"
          },
          {
            "code" : "10304000",
            "display" : "Gargle, tablet for solution"
          },
          {
            "code" : "50024000",
            "display" : "Gargle/mouthwash"
          },
          {
            "code" : "50024500",
            "display" : "Gargle/nasal wash"
          },
          {
            "code" : "13012000",
            "display" : "Gas for dispersion for infusion"
          },
          {
            "code" : "13013000",
            "display" : "Gas for dispersion for injection"
          },
          {
            "code" : "13050000",
            "display" : "Gas for dispersion for injection/infusion"
          },
          {
            "code" : "12111000",
            "display" : "Gastroenteral emulsion"
          },
          {
            "code" : "12108000",
            "display" : "Gastroenteral solution"
          },
          {
            "code" : "12110000",
            "display" : "Gastroenteral suspension"
          },
          {
            "code" : "10212000",
            "display" : "Gastro-resistant capsule, hard"
          },
          {
            "code" : "10213000",
            "display" : "Gastro-resistant capsule, soft"
          },
          {
            "code" : "10206000",
            "display" : "Gastro-resistant granules"
          },
          {
            "code" : "50026000",
            "display" : "Gastro-resistant granules for oral suspension"
          },
          {
            "code" : "13133000",
            "display" : "Gastro-resistant oral suspension"
          },
          {
            "code" : "13136000",
            "display" : "Gastro-resistant powder for oral suspension"
          },
          {
            "code" : "10225000",
            "display" : "Gastro-resistant tablet"
          },
          {
            "code" : "10503000",
            "display" : "Gel"
          },
          {
            "code" : "13014000",
            "display" : "Gel for gel"
          },
          {
            "code" : "11204000",
            "display" : "Gel for injection"
          },
          {
            "code" : "10315000",
            "display" : "Gingival gel"
          },
          {
            "code" : "10316000",
            "display" : "Gingival paste"
          },
          {
            "code" : "10312000",
            "display" : "Gingival solution"
          },
          {
            "code" : "10204000",
            "display" : "Granules"
          },
          {
            "code" : "10112000",
            "display" : "Granules for oral solution"
          },
          {
            "code" : "10113000",
            "display" : "Granules for oral suspension"
          },
          {
            "code" : "50029150",
            "display" : "Granules for oral/rectal suspension"
          },
          {
            "code" : "13015000",
            "display" : "Granules for rectal suspension"
          },
          {
            "code" : "13048000",
            "display" : "Granules for suspension for injection"
          },
          {
            "code" : "10119000",
            "display" : "Granules for syrup"
          },
          {
            "code" : "50029500",
            "display" : "Granules for vaginal solution"
          },
          {
            "code" : "10122000",
            "display" : "Herbal tea"
          },
          {
            "code" : "11301000",
            "display" : "Implant"
          },
          {
            "code" : "11303000",
            "display" : "Implantation chain"
          },
          {
            "code" : "11303300",
            "display" : "Implantation matrix"
          },
          {
            "code" : "13043000",
            "display" : "Implantation paste"
          },
          {
            "code" : "11303500",
            "display" : "Implantation suspension"
          },
          {
            "code" : "11302000",
            "display" : "Implantation tablet"
          },
          {
            "code" : "13145000",
            "display" : "Impregnated cutaneous swab"
          },
          {
            "code" : "10525000",
            "display" : "Impregnated dressing"
          },
          {
            "code" : "12117000",
            "display" : "Impregnated pad"
          },
          {
            "code" : "12117500",
            "display" : "Impregnated plug"
          },
          {
            "code" : "11109000",
            "display" : "Inhalation powder"
          },
          {
            "code" : "11110000",
            "display" : "Inhalation powder, hard capsule"
          },
          {
            "code" : "11111000",
            "display" : "Inhalation powder, pre-dispensed"
          },
          {
            "code" : "50030000",
            "display" : "Inhalation powder, tablet"
          },
          {
            "code" : "50081000",
            "display" : "Inhalation solution"
          },
          {
            "code" : "11113000",
            "display" : "Inhalation vapour, capsule"
          },
          {
            "code" : "50031000",
            "display" : "Inhalation vapour, effervescent tablet"
          },
          {
            "code" : "50032000",
            "display" : "Inhalation vapour, emulsion"
          },
          {
            "code" : "50033000",
            "display" : "Inhalation vapour, impregnated pad"
          },
          {
            "code" : "50033100",
            "display" : "Inhalation vapour, impregnated plug"
          },
          {
            "code" : "11117000",
            "display" : "Inhalation vapour, liquid"
          },
          {
            "code" : "11116000",
            "display" : "Inhalation vapour, ointment"
          },
          {
            "code" : "11112000",
            "display" : "Inhalation vapour, powder"
          },
          {
            "code" : "11114000",
            "display" : "Inhalation vapour, solution"
          },
          {
            "code" : "11115000",
            "display" : "Inhalation vapour, tablet"
          },
          {
            "code" : "10202000",
            "display" : "Instant herbal tea"
          },
          {
            "code" : "12120000",
            "display" : "Intestinal gel"
          },
          {
            "code" : "13044000",
            "display" : "Intraocular instillation solution"
          },
          {
            "code" : "12111500",
            "display" : "Intraperitoneal solution"
          },
          {
            "code" : "11901000",
            "display" : "Intrauterine delivery system"
          },
          {
            "code" : "13113000",
            "display" : "Intrauterine gel"
          },
          {
            "code" : "11502500",
            "display" : "Intravesical solution"
          },
          {
            "code" : "50033400",
            "display" : "Intravesical solution/solution for injection"
          },
          {
            "code" : "13045000",
            "display" : "Intravesical suspension"
          },
          {
            "code" : "12113000",
            "display" : "Irrigation solution"
          },
          {
            "code" : "12107000",
            "display" : "Kit for radiopharmaceutical preparation"
          },
          {
            "code" : "13016000",
            "display" : "Laryngopharyngeal solution"
          },
          {
            "code" : "13017000",
            "display" : "Laryngopharyngeal spray, solution"
          },
          {
            "code" : "12118000",
            "display" : "Living tissue equivalent"
          },
          {
            "code" : "10321000",
            "display" : "Lozenge"
          },
          {
            "code" : "13018000",
            "display" : "Matrix for implantation matrix"
          },
          {
            "code" : "10229000",
            "display" : "Medicated chewing-gum"
          },
          {
            "code" : "10521000",
            "display" : "Medicated nail lacquer"
          },
          {
            "code" : "10506000",
            "display" : "Medicated plaster"
          },
          {
            "code" : "12119000",
            "display" : "Medicated sponge"
          },
          {
            "code" : "12130000",
            "display" : "Medicated thread"
          },
          {
            "code" : "10914000",
            "display" : "Medicated vaginal tampon"
          },
          {
            "code" : "12301000",
            "display" : "Medicinal gas, compressed"
          },
          {
            "code" : "12302000",
            "display" : "Medicinal gas, cryogenic"
          },
          {
            "code" : "12303000",
            "display" : "Medicinal gas, liquefied"
          },
          {
            "code" : "13124000",
            "display" : "Medicinal larvae"
          },
          {
            "code" : "13115000",
            "display" : "Medicinal leech"
          },
          {
            "code" : "10217000",
            "display" : "Modified-release capsule, hard"
          },
          {
            "code" : "10218000",
            "display" : "Modified-release capsule, soft"
          },
          {
            "code" : "10208000",
            "display" : "Modified-release granules"
          },
          {
            "code" : "50036000",
            "display" : "Modified-release granules for oral suspension"
          },
          {
            "code" : "13135000",
            "display" : "Modified-release oral suspension"
          },
          {
            "code" : "10227000",
            "display" : "Modified-release tablet"
          },
          {
            "code" : "10310000",
            "display" : "Mouthwash"
          },
          {
            "code" : "50036050",
            "display" : "Mouthwash, powder for solution"
          },
          {
            "code" : "10311000",
            "display" : "Mouthwash, tablet for solution"
          },
          {
            "code" : "10319000",
            "display" : "Muco-adhesive buccal tablet"
          },
          {
            "code" : "10801000",
            "display" : "Nasal cream"
          },
          {
            "code" : "10806000",
            "display" : "Nasal drops, emulsion"
          },
          {
            "code" : "13020000",
            "display" : "Nasal drops, powder for solution"
          },
          {
            "code" : "10804000",
            "display" : "Nasal drops, solution"
          },
          {
            "code" : "10805000",
            "display" : "Nasal drops, suspension"
          },
          {
            "code" : "10802000",
            "display" : "Nasal gel"
          },
          {
            "code" : "10803000",
            "display" : "Nasal ointment"
          },
          {
            "code" : "10807000",
            "display" : "Nasal powder"
          },
          {
            "code" : "10810000",
            "display" : "Nasal spray, emulsion"
          },
          {
            "code" : "50037100",
            "display" : "Nasal spray, powder for solution"
          },
          {
            "code" : "10808000",
            "display" : "Nasal spray, solution"
          },
          {
            "code" : "50037400",
            "display" : "Nasal spray, solution/oromucosal solution"
          },
          {
            "code" : "10809000",
            "display" : "Nasal spray, suspension"
          },
          {
            "code" : "10812000",
            "display" : "Nasal stick"
          },
          {
            "code" : "10811000",
            "display" : "Nasal wash"
          },
          {
            "code" : "50036500",
            "display" : "Nasal/oromucosal solution"
          },
          {
            "code" : "50036700",
            "display" : "Nasal/oromucosal spray, solution"
          },
          {
            "code" : "13129000",
            "display" : "Nebuliser dispersion"
          },
          {
            "code" : "11105000",
            "display" : "Nebuliser emulsion"
          },
          {
            "code" : "11101000",
            "display" : "Nebuliser solution"
          },
          {
            "code" : "11102000",
            "display" : "Nebuliser suspension"
          },
          {
            "code" : "10504000",
            "display" : "Ointment"
          },
          {
            "code" : "10612000",
            "display" : "Ophthalmic insert"
          },
          {
            "code" : "10613000",
            "display" : "Ophthalmic strip"
          },
          {
            "code" : "10103000",
            "display" : "Oral drops, emulsion"
          },
          {
            "code" : "50037500",
            "display" : "Oral drops, granules for solution"
          },
          {
            "code" : "50037750",
            "display" : "Oral drops, liquid"
          },
          {
            "code" : "50082000",
            "display" : "Oral drops, powder for suspension"
          },
          {
            "code" : "10101000",
            "display" : "Oral drops, solution"
          },
          {
            "code" : "10102000",
            "display" : "Oral drops, suspension"
          },
          {
            "code" : "10107000",
            "display" : "Oral emulsion"
          },
          {
            "code" : "10108000",
            "display" : "Oral gel"
          },
          {
            "code" : "10230000",
            "display" : "Oral gum"
          },
          {
            "code" : "13106000",
            "display" : "Oral herbal material"
          },
          {
            "code" : "10104000",
            "display" : "Oral liquid"
          },
          {
            "code" : "10224000",
            "display" : "Oral lyophilisate"
          },
          {
            "code" : "10109000",
            "display" : "Oral paste"
          },
          {
            "code" : "10201000",
            "display" : "Oral powder"
          },
          {
            "code" : "10105000",
            "display" : "Oral solution"
          },
          {
            "code" : "50038500",
            "display" : "Oral solution/concentrate for nebuliser solution"
          },
          {
            "code" : "10106000",
            "display" : "Oral suspension"
          },
          {
            "code" : "50037900",
            "display" : "Oral/rectal solution"
          },
          {
            "code" : "50038000",
            "display" : "Oral/rectal suspension"
          },
          {
            "code" : "10236100",
            "display" : "Orodispersible film"
          },
          {
            "code" : "10223000",
            "display" : "Orodispersible tablet"
          },
          {
            "code" : "10317000",
            "display" : "Oromucosal capsule"
          },
          {
            "code" : "10314010",
            "display" : "Oromucosal cream"
          },
          {
            "code" : "10307000",
            "display" : "Oromucosal drops"
          },
          {
            "code" : "13149000",
            "display" : "Oromucosal film"
          },
          {
            "code" : "10313000",
            "display" : "Oromucosal gel"
          },
          {
            "code" : "10314005",
            "display" : "Oromucosal ointment"
          },
          {
            "code" : "10314000",
            "display" : "Oromucosal paste"
          },
          {
            "code" : "50039000",
            "display" : "Oromucosal patch"
          },
          {
            "code" : "13141000",
            "display" : "Oromucosal pouch"
          },
          {
            "code" : "10305000",
            "display" : "Oromucosal solution"
          },
          {
            "code" : "10308100",
            "display" : "Oromucosal spray, emulsion"
          },
          {
            "code" : "10308200",
            "display" : "Oromucosal spray, solution"
          },
          {
            "code" : "10308300",
            "display" : "Oromucosal spray, suspension"
          },
          {
            "code" : "10306000",
            "display" : "Oromucosal suspension"
          },
          {
            "code" : "50039500",
            "display" : "Oromucosal/laryngopharyngeal solution"
          },
          {
            "code" : "50040500",
            "display" : "Oromucosal/laryngopharyngeal solution/spray, solution"
          },
          {
            "code" : "10323000",
            "display" : "Pastille"
          },
          {
            "code" : "10410000",
            "display" : "Periodontal gel"
          },
          {
            "code" : "10411000",
            "display" : "Periodontal insert"
          },
          {
            "code" : "10401000",
            "display" : "Periodontal powder"
          },
          {
            "code" : "10909000",
            "display" : "Pessary"
          },
          {
            "code" : "10231000",
            "display" : "Pillules"
          },
          {
            "code" : "10550000",
            "display" : "Plaster for provocation test"
          },
          {
            "code" : "10522000",
            "display" : "Poultice"
          },
          {
            "code" : "11503000",
            "display" : "Powder for bladder irrigation"
          },
          {
            "code" : "50048750",
            "display" : "Powder for concentrate for dispersion for infusion"
          },
          {
            "code" : "50049100",
            "display" : "Powder for concentrate for intravesical suspension"
          },
          {
            "code" : "50049200",
            "display" : "Powder for concentrate for solution for haemodialysis"
          },
          {
            "code" : "50043000",
            "display" : "Powder for concentrate for solution for infusion"
          },
          {
            "code" : "50049250",
            "display" : "Powder for concentrate for solution for injection/infusion"
          },
          {
            "code" : "10514500",
            "display" : "Powder for cutaneous solution"
          },
          {
            "code" : "10413000",
            "display" : "Powder for dental cement"
          },
          {
            "code" : "13022000",
            "display" : "Powder for dental gel"
          },
          {
            "code" : "50049270",
            "display" : "Powder for dental solution"
          },
          {
            "code" : "11211500",
            "display" : "Powder for dispersion for infusion"
          },
          {
            "code" : "13023000",
            "display" : "Powder for dispersion for injection"
          },
          {
            "code" : "13040000",
            "display" : "Powder for emulsion for injection"
          },
          {
            "code" : "13024000",
            "display" : "Powder for endocervical gel"
          },
          {
            "code" : "13025000",
            "display" : "Powder for endosinusial solution"
          },
          {
            "code" : "50049300",
            "display" : "Powder for epilesional solution"
          },
          {
            "code" : "13021000",
            "display" : "Powder for gel"
          },
          {
            "code" : "13026000",
            "display" : "Powder for gingival gel"
          },
          {
            "code" : "13027000",
            "display" : "Powder for implantation matrix"
          },
          {
            "code" : "13028000",
            "display" : "Powder for implantation paste"
          },
          {
            "code" : "50049500",
            "display" : "Powder for implantation suspension"
          },
          {
            "code" : "13029000",
            "display" : "Powder for intraocular instillation solution"
          },
          {
            "code" : "50050000",
            "display" : "Powder for intravesical solution"
          },
          {
            "code" : "50050500",
            "display" : "Powder for intravesical solution/solution for injection"
          },
          {
            "code" : "50051000",
            "display" : "Powder for intravesical suspension"
          },
          {
            "code" : "11104000",
            "display" : "Powder for nebuliser solution"
          },
          {
            "code" : "11103000",
            "display" : "Powder for nebuliser suspension"
          },
          {
            "code" : "10110000",
            "display" : "Powder for oral solution"
          },
          {
            "code" : "10111000",
            "display" : "Powder for oral suspension"
          },
          {
            "code" : "50052000",
            "display" : "Powder for oral/rectal suspension"
          },
          {
            "code" : "11208400",
            "display" : "Powder for prolonged-release suspension for injection"
          },
          {
            "code" : "11009000",
            "display" : "Powder for rectal solution"
          },
          {
            "code" : "11010000",
            "display" : "Powder for rectal suspension"
          },
          {
            "code" : "13031000",
            "display" : "Powder for sealant"
          },
          {
            "code" : "11212000",
            "display" : "Powder for solution for infusion"
          },
          {
            "code" : "11205000",
            "display" : "Powder for solution for injection"
          },
          {
            "code" : "50053500",
            "display" : "Powder for solution for injection/infusion"
          },
          {
            "code" : "13052000",
            "display" : "Powder for solution for injection/skin-prick test"
          },
          {
            "code" : "50073000",
            "display" : "Powder for solution for intraocular irrigation"
          },
          {
            "code" : "10518500",
            "display" : "Powder for solution for iontophoresis"
          },
          {
            "code" : "13032000",
            "display" : "Powder for solution for skin-prick test"
          },
          {
            "code" : "11206000",
            "display" : "Powder for suspension for injection"
          },
          {
            "code" : "10118000",
            "display" : "Powder for syrup"
          },
          {
            "code" : "13111000",
            "display" : "Powder for vaginal solution"
          },
          {
            "code" : "11108000",
            "display" : "Pressurised inhalation, emulsion"
          },
          {
            "code" : "11106000",
            "display" : "Pressurised inhalation, solution"
          },
          {
            "code" : "11107000",
            "display" : "Pressurised inhalation, suspension"
          },
          {
            "code" : "10215000",
            "display" : "Prolonged-release capsule, hard"
          },
          {
            "code" : "10216000",
            "display" : "Prolonged-release capsule, soft"
          },
          {
            "code" : "13126000",
            "display" : "Prolonged-release dispersion for injection"
          },
          {
            "code" : "10207000",
            "display" : "Prolonged-release granules"
          },
          {
            "code" : "50056000",
            "display" : "Prolonged-release granules for oral suspension"
          },
          {
            "code" : "13134000",
            "display" : "Prolonged-release oral suspension"
          },
          {
            "code" : "13148000",
            "display" : "Prolonged-release pessary"
          },
          {
            "code" : "13076000",
            "display" : "Prolonged-release solution for injection"
          },
          {
            "code" : "11208500",
            "display" : "Prolonged-release suspension for injection"
          },
          {
            "code" : "10226000",
            "display" : "Prolonged-release tablet"
          },
          {
            "code" : "13128000",
            "display" : "Prolonged-release wound solution"
          },
          {
            "code" : "12106000",
            "display" : "Radionuclide generator"
          },
          {
            "code" : "12105000",
            "display" : "Radiopharmaceutical precursor"
          },
          {
            "code" : "50056500",
            "display" : "Radiopharmaceutical precursor, solution"
          },
          {
            "code" : "11014000",
            "display" : "Rectal capsule"
          },
          {
            "code" : "11001000",
            "display" : "Rectal cream"
          },
          {
            "code" : "11007000",
            "display" : "Rectal emulsion"
          },
          {
            "code" : "11004000",
            "display" : "Rectal foam"
          },
          {
            "code" : "11002000",
            "display" : "Rectal gel"
          },
          {
            "code" : "11003000",
            "display" : "Rectal ointment"
          },
          {
            "code" : "11005000",
            "display" : "Rectal solution"
          },
          {
            "code" : "11006000",
            "display" : "Rectal suspension"
          },
          {
            "code" : "11015000",
            "display" : "Rectal tampon"
          },
          {
            "code" : "12115000",
            "display" : "Sealant"
          },
          {
            "code" : "12115100",
            "display" : "Sealant matrix"
          },
          {
            "code" : "12115200",
            "display" : "Sealant powder"
          },
          {
            "code" : "10508000",
            "display" : "Shampoo"
          },
          {
            "code" : "10120000",
            "display" : "Soluble tablet"
          },
          {
            "code" : "12103000",
            "display" : "Solution for blood fraction modification"
          },
          {
            "code" : "11209500",
            "display" : "Solution for cardioplegia"
          },
          {
            "code" : "13107000",
            "display" : "Solution for cardioplegia/organ preservation"
          },
          {
            "code" : "10414000",
            "display" : "Solution for dental cement"
          },
          {
            "code" : "11403000",
            "display" : "Solution for haemodiafiltration"
          },
          {
            "code" : "11404000",
            "display" : "Solution for haemodialysis"
          },
          {
            "code" : "50057000",
            "display" : "Solution for haemodialysis/haemofiltration"
          },
          {
            "code" : "11402000",
            "display" : "Solution for haemofiltration"
          },
          {
            "code" : "11210000",
            "display" : "Solution for infusion"
          },
          {
            "code" : "11201000",
            "display" : "Solution for injection"
          },
          {
            "code" : "50060000",
            "display" : "Solution for injection/infusion"
          },
          {
            "code" : "13051000",
            "display" : "Solution for injection/skin-prick test"
          },
          {
            "code" : "50073500",
            "display" : "Solution for intraocular irrigation"
          },
          {
            "code" : "10518000",
            "display" : "Solution for iontophoresis"
          },
          {
            "code" : "12112000",
            "display" : "Solution for organ preservation"
          },
          {
            "code" : "11401000",
            "display" : "Solution for peritoneal dialysis"
          },
          {
            "code" : "12131000",
            "display" : "Solution for provocation test"
          },
          {
            "code" : "50061500",
            "display" : "Solution for sealant"
          },
          {
            "code" : "10548000",
            "display" : "Solution for skin-prick test"
          },
          {
            "code" : "10549000",
            "display" : "Solution for skin-scratch test"
          },
          {
            "code" : "13061000",
            "display" : "Solution for solution for infusion"
          },
          {
            "code" : "13033000",
            "display" : "Solution for solution for injection"
          },
          {
            "code" : "13047000",
            "display" : "Solution for suspension for injection"
          },
          {
            "code" : "11216000",
            "display" : "Solvent for parenteral use"
          },
          {
            "code" : "50076000",
            "display" : "Solvent for solution for infusion"
          },
          {
            "code" : "50074000",
            "display" : "Solvent for solution for intraocular irrigation"
          },
          {
            "code" : "13035000",
            "display" : "Solvent for..."
          },
          {
            "code" : "12114000",
            "display" : "Stomach irrigation"
          },
          {
            "code" : "10317500",
            "display" : "Sublingual film"
          },
          {
            "code" : "13127000",
            "display" : "Sublingual lyophilisate"
          },
          {
            "code" : "13105000",
            "display" : "Sublingual powder"
          },
          {
            "code" : "10309100",
            "display" : "Sublingual spray, emulsion"
          },
          {
            "code" : "10309200",
            "display" : "Sublingual spray, solution"
          },
          {
            "code" : "10309300",
            "display" : "Sublingual spray, suspension"
          },
          {
            "code" : "10318000",
            "display" : "Sublingual tablet"
          },
          {
            "code" : "11013000",
            "display" : "Suppository"
          },
          {
            "code" : "13036000",
            "display" : "Suspension for emulsion for injection"
          },
          {
            "code" : "13165000",
            "display" : "Suspension for gel"
          },
          {
            "code" : "11202000",
            "display" : "Suspension for injection"
          },
          {
            "code" : "13037000",
            "display" : "Suspension for oral suspension"
          },
          {
            "code" : "13039000",
            "display" : "Suspension for suspension for injection"
          },
          {
            "code" : "10117000",
            "display" : "Syrup"
          },
          {
            "code" : "10219000",
            "display" : "Tablet"
          },
          {
            "code" : "13066000",
            "display" : "Tablet for cutaneous solution"
          },
          {
            "code" : "11011000",
            "display" : "Tablet for rectal solution"
          },
          {
            "code" : "11012000",
            "display" : "Tablet for rectal suspension"
          },
          {
            "code" : "10908000",
            "display" : "Tablet for vaginal solution"
          },
          {
            "code" : "13118000",
            "display" : "Tablet with sensor"
          },
          {
            "code" : "10409000",
            "display" : "Toothpaste"
          },
          {
            "code" : "10546250",
            "display" : "Transdermal gel"
          },
          {
            "code" : "13102000",
            "display" : "Transdermal ointment"
          },
          {
            "code" : "10519000",
            "display" : "Transdermal patch"
          },
          {
            "code" : "10546400",
            "display" : "Transdermal solution"
          },
          {
            "code" : "10546500",
            "display" : "Transdermal spray, solution"
          },
          {
            "code" : "10547000",
            "display" : "Transdermal system"
          },
          {
            "code" : "13077000",
            "display" : "Urethral emulsion"
          },
          {
            "code" : "11504000",
            "display" : "Urethral gel"
          },
          {
            "code" : "13123000",
            "display" : "Urethral ointment"
          },
          {
            "code" : "11505000",
            "display" : "Urethral stick"
          },
          {
            "code" : "10910000",
            "display" : "Vaginal capsule, hard"
          },
          {
            "code" : "10911000",
            "display" : "Vaginal capsule, soft"
          },
          {
            "code" : "10901000",
            "display" : "Vaginal cream"
          },
          {
            "code" : "10915000",
            "display" : "Vaginal delivery system"
          },
          {
            "code" : "10907000",
            "display" : "Vaginal emulsion"
          },
          {
            "code" : "10904000",
            "display" : "Vaginal foam"
          },
          {
            "code" : "10902000",
            "display" : "Vaginal gel"
          },
          {
            "code" : "10903000",
            "display" : "Vaginal ointment"
          },
          {
            "code" : "10905000",
            "display" : "Vaginal solution"
          },
          {
            "code" : "10906000",
            "display" : "Vaginal suspension"
          },
          {
            "code" : "10912000",
            "display" : "Vaginal tablet"
          },
          {
            "code" : "12104000",
            "display" : "Wound stick"
          }
        ]
      }
    ]
  }
}

```
