# EDQM PDF characteristics: Release Characteristics - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EDQM PDF characteristics: Release Characteristics**

## ValueSet: EDQM PDF characteristics: Release Characteristics 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ValueSet/edqm-RCA | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:edqm-RCA |

 
EDQM Pharmaceutical dose forms characteristics: Release Characteristics 

 **References** 

* [Pharmaceutical dose form - ReleaseCharacteristics](StructureDefinition-release-characteristics.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "edqm-RCA",
  "url" : "http://who-umc.org/idmp/ValueSet/edqm-RCA",
  "version" : "0.1.0",
  "name" : "edqm-RCA",
  "title" : "EDQM PDF characteristics: Release Characteristics",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "EDQM Pharmaceutical dose forms characteristics: Release Characteristics",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "concept" : [
          {
            "code" : "RCA-0044",
            "display" : "Delayed"
          },
          {
            "code" : "RCA-0045",
            "display" : "Prolonged"
          },
          {
            "code" : "RCA-0046",
            "display" : "Modified"
          },
          {
            "code" : "RCA-0047",
            "display" : "Conventional"
          },
          {
            "code" : "RCA-0048",
            "display" : "Unknown"
          }
        ]
      }
    ]
  }
}

```
