# EDQM PDF characteristics: Basic Dose Form - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EDQM PDF characteristics: Basic Dose Form**

## ValueSet: EDQM PDF characteristics: Basic Dose Form 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ValueSet/edqm-BDF | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:edqm-BDF |

 
EDQM Pharmaceutical dose forms characteristics: Basic Dose Form 

 **References** 

* [Pharmaceutical dose form - BasicDoseForm](StructureDefinition-basic-dose-form.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "edqm-BDF",
  "url" : "http://who-umc.org/idmp/ValueSet/edqm-BDF",
  "version" : "0.1.0",
  "name" : "edqm-BDF",
  "title" : "EDQM PDF characteristics: Basic Dose Form",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "EDQM Pharmaceutical dose forms characteristics: Basic Dose Form",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://who-umc.org/idmp/CodeSystem/edqmDoseFormAttributes",
        "concept" : [
          {
            "code" : "BDF-0049",
            "display" : "Block"
          },
          {
            "code" : "BDF-0050",
            "display" : "Cachet"
          },
          {
            "code" : "BDF-0051",
            "display" : "Capsule"
          },
          {
            "code" : "BDF-0052",
            "display" : "Film"
          },
          {
            "code" : "BDF-0053",
            "display" : "Granules"
          },
          {
            "code" : "BDF-0054",
            "display" : "Gum"
          },
          {
            "code" : "BDF-0055",
            "display" : "Implant"
          },
          {
            "code" : "BDF-0056",
            "display" : "Impregnated material"
          },
          {
            "code" : "BDF-0058",
            "display" : "Lozenge"
          },
          {
            "code" : "BDF-0059",
            "display" : "Lyophilisate"
          },
          {
            "code" : "BDF-0060",
            "display" : "Pastille"
          },
          {
            "code" : "BDF-0061",
            "display" : "Patch"
          },
          {
            "code" : "BDF-0063",
            "display" : "Pessary"
          },
          {
            "code" : "BDF-0064",
            "display" : "Pillules"
          },
          {
            "code" : "BDF-0066",
            "display" : "Powder"
          },
          {
            "code" : "BDF-0067",
            "display" : "Stick"
          },
          {
            "code" : "BDF-0068",
            "display" : "Suppository"
          },
          {
            "code" : "BDF-0069",
            "display" : "Tablet"
          },
          {
            "code" : "BDF-0070",
            "display" : "Tea"
          },
          {
            "code" : "BDF-0071",
            "display" : "Cream"
          },
          {
            "code" : "BDF-0072",
            "display" : "Foam"
          },
          {
            "code" : "BDF-0073",
            "display" : "Gel"
          },
          {
            "code" : "BDF-0074",
            "display" : "Ointment"
          },
          {
            "code" : "BDF-0075",
            "display" : "Paste"
          },
          {
            "code" : "BDF-0076",
            "display" : "Poultice"
          },
          {
            "code" : "BDF-0077",
            "display" : "Collodion"
          },
          {
            "code" : "BDF-0080",
            "display" : "Emulsion"
          },
          {
            "code" : "BDF-0081",
            "display" : "Lacquer"
          },
          {
            "code" : "BDF-0082",
            "display" : "Liquid"
          },
          {
            "code" : "BDF-0083",
            "display" : "Solution"
          },
          {
            "code" : "BDF-0084",
            "display" : "Solvent"
          },
          {
            "code" : "BDF-0085",
            "display" : "Suspension"
          },
          {
            "code" : "BDF-0087",
            "display" : "Medicinal gas"
          },
          {
            "code" : "BDF-0088",
            "display" : "Insert"
          },
          {
            "code" : "BDF-0093",
            "display" : "Shampoo"
          },
          {
            "code" : "BDF-0095",
            "display" : "System"
          },
          {
            "code" : "BDF-0102",
            "display" : "Pouch"
          },
          {
            "code" : "BDF-0103",
            "display" : "Cement"
          },
          {
            "code" : "BDF-0114",
            "display" : "Herbal material (unprocessed)"
          },
          {
            "code" : "BDF-0115",
            "display" : "Live animal"
          }
        ]
      }
    ]
  }
}

```
