# Example of a completed Task - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example of a completed Task**

## Example Task: Example of a completed Task

Template for PhPID request Task



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "task-completed-phpid",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2021-03-21T08:24:09.8508147+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/Task-who-php-phpid-status"
    ]
  },
  "contained" : [
    {
      "resourceType" : "MedicinalProductDefinition",
      "id" : "3e8d3895-d37c-41da-8372-face4978b4d5",
      "meta" : {
        "source" : "https://poc-idmp.who-umc.org/fhir",
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req"
        ]
      },
      "identifier" : [
        {
          "system" : "http://ema.europa.eu/example/mpid",
          "value" : "MPID-123"
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/medicinal-product-type",
            "code" : "MedicinalProduct"
          }
        ]
      },
      "domain" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/medicinal-product-domain",
            "code" : "Human"
          }
        ],
        "text" : "Human use"
      },
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "combinedPharmaceuticalDoseForm" : {
        "text" : "tablet"
      },
      "attachedDocument" : [
        {
          "display" : "SPC/123"
        }
      ],
      "name" : [
        {
          "productName" : "Marvelol",
          "usage" : [
            {
              "country" : {
                "coding" : [
                  {
                    "system" : "urn:iso:std:iso:3166",
                    "code" : "NLD"
                  }
                ]
              },
              "jurisdiction" : {
                "coding" : [
                  {
                    "system" : "http://who-umc.org/idmp/CodeSystem/jurisdiction",
                    "code" : "EU"
                  }
                ]
              },
              "language" : {
                "coding" : [
                  {
                    "system" : "urn:ietf:bcp:47",
                    "code" : "nl"
                  }
                ]
              }
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "Ingredient",
      "id" : "cd7f7d98-75eb-4a6f-9252-dc57c0ee9e34",
      "meta" : {
        "source" : "https://poc-idmp.who-umc.org/fhir",
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php"
        ]
      },
      "status" : "active",
      "for" : [
        {
          "reference" : "#3e8d3895-d37c-41da-8372-face4978b4d5"
        }
      ],
      "role" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/ingredient-role",
            "code" : "100000072072"
          }
        ],
        "text" : "Active"
      },
      "substance" : {
        "code" : {
          "concept" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/gsid",
                "code" : "GSID23G92UMX93H45"
              }
            ],
            "text" : "Methotrexate"
          }
        },
        "strength" : [
          {
            "presentationRatio" : {
              "numerator" : {
                "value" : 1.5,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "IU",
                "system" : "http://who-umc.org/idmp/CodeSystem/strengthUnit",
                "code" : "IU"
              }
            },
            "textPresentation" : "1,5 mg"
          }
        ]
      }
    },
    {
      "resourceType" : "Organization",
      "id" : "acmeinc",
      "meta" : {
        "source" : "https://poc-idmp.who-umc.org/fhir",
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/MarketingAuthorizationHolder-who-php"
        ]
      },
      "active" : true,
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
              "code" : "bus"
            }
          ],
          "text" : "Non-Healthcare Business or Corporation"
        }
      ],
      "name" : "Acme Inc"
    },
    {
      "resourceType" : "RegulatedAuthorization",
      "id" : "066bb2b6-5b34-4ea8-9c73-6d95d402672d",
      "identifier" : [
        {
          "system" : "http://ema.europa.eu/ema/",
          "value" : "EU/1/20/XXXX"
        }
      ],
      "subject" : [
        {
          "reference" : "#3e8d3895-d37c-41da-8372-face4978b4d5"
        }
      ],
      "holder" : {
        "reference" : "#acmeinc"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://requester.org/phpidreqid",
      "value" : "123456"
    }
  ],
  "status" : "completed",
  "intent" : "proposal",
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://who-umc.org/idmp/CodeSystem/task-request-code",
        "code" : "phpid-request"
      }
    ]
  },
  "authoredOn" : "2025-06-18",
  "lastModified" : "2025-06-18",
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
            "code" : "mpd-request-resource",
            "display" : "Medicinal Product for PhPID request"
          }
        ]
      },
      "valueReference" : {
        "reference" : "#3e8d3895-d37c-41da-8372-face4978b4d5"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
            "code" : "ingredient-request-resource",
            "display" : "Ingredient for PhPID request"
          }
        ]
      },
      "valueReference" : {
        "reference" : "#cd7f7d98-75eb-4a6f-9252-dc57c0ee9e34"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
            "code" : "organization-request-resource",
            "display" : "Marketing Auth Holder for PhPID request"
          }
        ]
      },
      "valueReference" : {
        "reference" : "#acmeinc"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
            "code" : "regauth-request-resource",
            "display" : "Regulated Authorization for PhPID request"
          }
        ]
      },
      "valueReference" : {
        "reference" : "#066bb2b6-5b34-4ea8-9c73-6d95d402672d"
      }
    }
  ],
  "output" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/task-output-type",
            "code" : "phpid",
            "display" : "PhPID"
          }
        ]
      },
      "valueReference" : {
        "reference" : "AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
                "code" : "PhPIDLevel4",
                "display" : "Level 4"
              }
            ]
          },
          "system" : "http://who-umc.org/idmp/phpid",
          "value" : "91B3CA582581F57E4092F13AAF476215"
        }
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/task-output-type",
            "code" : "whodrugid",
            "display" : "Medicinal Product (WHODrug) ID"
          }
        ]
      },
      "valueReference" : {
        "identifier" : {
          "system" : "http://who-umc.org/idmp/whodrugid",
          "value" : "XXXXXX"
        }
      }
    }
  ]
}

```
