# Substance (METHOTREXATE SODIUM) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance (METHOTREXATE SODIUM)**

## Example SubstanceDefinition: Substance (METHOTREXATE SODIUM)

# Substance definition

| | |
| :--- | :--- |
| Id | GSID9XBS2KCF3K1Z1 |
| SMILES | CN(Cc1cnc2c(c(N)[nH]c(=N)n2)n1)c3ccc(cc3)C(=O)N[C@@]([H])(CCC(=O)[O-])C(=O)[O-].[Na+].[Na+] |
| Base | GSID23G92UMX93H45 |

## Identifier(s)

| | |
| :--- | :--- |
| https://gupri-idmp.who-umc.org/data/substance | GSID9XBS2KCF3K1Z1 |

## Name(s)

| | | | |
| :--- | :--- | :--- | :--- |
| METHOTREXATE SODIUM | UMC-SRS | en | True |

## Other code systems

| | |
| :--- | :--- |
| http://terminology.hl7.org/CodeSystem/CAS | 15475-56-6 |
| https://open.fda.gov/data/unii | 3IG1E710ZN |
| http://terminology.hl7.org/CodeSystem/CAS | 7413-34-5 |



## Resource Content

```json
{
  "resourceType" : "SubstanceDefinition",
  "id" : "GSID9XBS2KCF3K1Z1",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-03-19T08:23:54.3465911+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub"
    ]
  },
  "identifier" : [
    {
      "system" : "https://gupri-idmp.who-umc.org/data/substance",
      "value" : "GSID9XBS2KCF3K1Z1"
    }
  ],
  "status" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/publication-status",
        "code" : "active"
      }
    ],
    "text" : "Active"
  },
  "domain" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-domain",
        "code" : "Human"
      }
    ],
    "text" : "Human use"
  },
  "structure" : {
    "representation" : [
      {
        "representation" : "CN(Cc1cnc2c(c(N)[nH]c(=N)n2)n1)c3ccc(cc3)C(=O)N[C@@]([H])(CCC(=O)[O-])C(=O)[O-].[Na+].[Na+]",
        "format" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/substance-representation-format",
              "code" : "SMILES"
            }
          ],
          "text" : "SMILES"
        }
      }
    ]
  },
  "code" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/CAS",
            "code" : "15475-56-6"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "https://open.fda.gov/data/unii",
            "code" : "3IG1E710ZN"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/CAS",
            "code" : "7413-34-5"
          }
        ]
      }
    }
  ],
  "name" : [
    {
      "name" : "METHOTREXATE SODIUM",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : true,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "UMC-SRS"
              }
            ],
            "text" : "UMC-SRS"
          }
        }
      ]
    }
  ],
  "relationship" : [
    {
      "substanceDefinitionReference" : {
        "reference" : "SubstanceDefinition/GSID23G92UMX93H45",
        "identifier" : {
          "system" : "https://gupri-idmp.who-umc.org/data/substance",
          "value" : "GSID23G92UMX93H45"
        }
      },
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/substance-relationship-type",
            "code" : "Salt"
          }
        ],
        "text" : "Salt to parent"
      }
    }
  ]
}

```
