# Substance (OMEPRAZOLE) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance (OMEPRAZOLE)**

## Example SubstanceDefinition: Substance (OMEPRAZOLE)

# Substance definition

| | |
| :--- | :--- |
| Id | GSID85RFP2XGF3X29 |
| SMILES | Cc1cnc(CS(=O)c2nc3ccc(cc3[nH]2)OC)c(C)c1OC |

## Identifier(s)

| | |
| :--- | :--- |
| https://gupri-idmp.who-umc.org/data/substance | GSID85RFP2XGF3X29 |

## Name(s)

| | | | |
| :--- | :--- | :--- | :--- |
| OMEPRAZOLE | INN | en | False |
| OMEPRAZOLE | UMC-SRS | en | True |
| OMEPRAZOLE | USAN | en | False |

## Other code systems

| | |
| :--- | :--- |
| http://terminology.hl7.org/CodeSystem/CAS | 73590-58-6 |
| https://open.fda.gov/data/unii | KG60484QX9 |



## Resource Content

```json
{
  "resourceType" : "SubstanceDefinition",
  "id" : "GSID85RFP2XGF3X29",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2019-10-15T08:23:54.2676192+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub"
    ]
  },
  "identifier" : [
    {
      "system" : "https://gupri-idmp.who-umc.org/data/substance",
      "value" : "GSID85RFP2XGF3X29"
    }
  ],
  "status" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/publication-status",
        "code" : "active"
      }
    ],
    "text" : "Active"
  },
  "domain" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-domain",
        "code" : "Human"
      }
    ],
    "text" : "Human use"
  },
  "structure" : {
    "representation" : [
      {
        "representation" : "Cc1cnc(CS(=O)c2nc3ccc(cc3[nH]2)OC)c(C)c1OC",
        "format" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/substance-representation-format",
              "code" : "SMILES"
            }
          ],
          "text" : "SMILES"
        }
      }
    ]
  },
  "code" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/CAS",
            "code" : "73590-58-6"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "https://open.fda.gov/data/unii",
            "code" : "KG60484QX9"
          }
        ]
      }
    }
  ],
  "name" : [
    {
      "name" : "OMEPRAZOLE",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : false,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "INN"
              }
            ],
            "text" : "INN"
          }
        }
      ]
    },
    {
      "name" : "OMEPRAZOLE",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : true,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "UMC-SRS"
              }
            ],
            "text" : "UMC-SRS"
          }
        }
      ]
    },
    {
      "name" : "OMEPRAZOLE",
      "status" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/publication-status",
            "code" : "active"
          }
        ],
        "text" : "Active"
      },
      "preferred" : false,
      "language" : [
        {
          "coding" : [
            {
              "system" : "urn:ietf:bcp:47",
              "code" : "en"
            }
          ]
        }
      ],
      "official" : [
        {
          "authority" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/substance-name-authority",
                "code" : "USAN"
              }
            ],
            "text" : "USAN"
          }
        }
      ]
    }
  ]
}

```
