# Parent PhP - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Parent PhP**

## Extension: Parent PhP 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/parent-phpid | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:ParentPhp |

This extension applies to the ADP resource and is used to refer the parent ADPs representing the upper level PhP.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [AdministrableProductDefinition (WHO PhP)](StructureDefinition-AdministrableProductDefinition-who-php.md)
* Examples for this Extension: [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md), [AdministrableProductDefinition/8195D4AF1287CCE3442C2F308F61DBBC](AdministrableProductDefinition-8195D4AF1287CCE3442C2F308F61DBBC.md) and [AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md)
* Search Parameters using this Extension: [parent-php](SearchParameter-parent-php.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/parent-phpid)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-parent-phpid.csv), [Excel](StructureDefinition-parent-phpid.xlsx), [Schematron](StructureDefinition-parent-phpid.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "parent-phpid",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid",
  "version" : "0.1.0",
  "name" : "ParentPhp",
  "title" : "Parent PhP",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This extension applies to the ADP resource and is used to refer the parent ADPs representing the upper level PhP.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "AdministrableProductDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Parent PhP",
        "definition" : "This extension applies to the ADP resource and is used to refer the parent ADPs representing the upper level PhP."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
            ]
          }
        ]
      },
      {
        "id" : "Extension.value[x].identifier",
        "path" : "Extension.value[x].identifier",
        "min" : 1
      },
      {
        "id" : "Extension.value[x].identifier.system",
        "path" : "Extension.value[x].identifier.system",
        "min" : 1,
        "patternUri" : "http://who-umc.org/idmp/phpid"
      }
    ]
  }
}

```
