# Task PhPID request status - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Task PhPID request status**

## Resource Profile: Task PhPID request status 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/Task-who-php-phpid-status | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:TaskGeneratePhPIDStatus |

 
This profile specified how to use the Task resource to request status of a previously sent request 

**Usages:**

* Examples for this Profile: [Task/task-completed-phpid](Task-task-completed-phpid.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/Task-who-php-phpid-status)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Task-who-php-phpid-status.csv), [Excel](StructureDefinition-Task-who-php-phpid-status.xlsx), [Schematron](StructureDefinition-Task-who-php-phpid-status.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Task-who-php-phpid-status",
  "url" : "http://who-umc.org/idmp/StructureDefinition/Task-who-php-phpid-status",
  "version" : "0.1.0",
  "name" : "TaskGeneratePhPIDStatus",
  "title" : "Task PhPID request status",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specified how to use the Task resource to request status of a previously sent request",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task"
      },
      {
        "id" : "Task.id",
        "path" : "Task.id",
        "min" : 1
      },
      {
        "id" : "Task.contained",
        "path" : "Task.contained",
        "short" : "Resources, according to 'input', used in PhPID generation.",
        "min" : 4
      },
      {
        "id" : "Task.identifier",
        "path" : "Task.identifier",
        "short" : "Identifier assigned by the requestor to track the request."
      },
      {
        "id" : "Task.instantiatesUri",
        "path" : "Task.instantiatesUri",
        "short" : "Link to the definiton of the task"
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "short" : "Status of the task",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/requestStatus"
        }
      },
      {
        "id" : "Task.businessStatus",
        "path" : "Task.businessStatus",
        "short" : "business-specific state"
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "patternCode" : "proposal"
      },
      {
        "id" : "Task.priority",
        "path" : "Task.priority",
        "short" : "Task priority"
      },
      {
        "id" : "Task.code",
        "path" : "Task.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://who-umc.org/idmp/CodeSystem/task-request-code",
              "code" : "phpid-request"
            }
          ]
        }
      },
      {
        "id" : "Task.encounter",
        "path" : "Task.encounter",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "min" : 1
      },
      {
        "id" : "Task.lastModified",
        "path" : "Task.lastModified",
        "min" : 1
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Task.insurance",
        "path" : "Task.insurance",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Task.restriction",
        "path" : "Task.restriction",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Task.input",
        "path" : "Task.input",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on the input.type value",
          "rules" : "open"
        },
        "min" : 4
      },
      {
        "id" : "Task.input:MPD",
        "path" : "Task.input",
        "sliceName" : "MPD",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:MPD.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
              "code" : "mpd-request-resource"
            }
          ]
        },
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/phpid-task-input-type"
        }
      },
      {
        "id" : "Task.input:MPD.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req"
            ]
          }
        ]
      },
      {
        "id" : "Task.input:ING",
        "path" : "Task.input",
        "sliceName" : "ING",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:ING.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
              "code" : "ingredient-request-resource"
            }
          ]
        },
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/phpid-task-input-type"
        }
      },
      {
        "id" : "Task.input:ING.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php"
            ]
          }
        ]
      },
      {
        "id" : "Task.input:ORG",
        "path" : "Task.input",
        "sliceName" : "ORG",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:ORG.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
              "code" : "organization-request-resource"
            }
          ]
        },
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/phpid-task-input-type"
        }
      },
      {
        "id" : "Task.input:ORG.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Organization"]
          }
        ]
      },
      {
        "id" : "Task.input:REGAUTH",
        "path" : "Task.input",
        "sliceName" : "REGAUTH",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:REGAUTH.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://who-umc.org/idmp/CodeSystem/task-input-type",
              "code" : "regauth-request-resource"
            }
          ]
        },
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/phpid-task-input-type"
        }
      },
      {
        "id" : "Task.input:REGAUTH.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/RegulatedAuthorization"
            ]
          }
        ]
      },
      {
        "id" : "Task.output",
        "path" : "Task.output",
        "max" : "5"
      },
      {
        "id" : "Task.output.type",
        "path" : "Task.output.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/phpid-task-output-type"
        }
      },
      {
        "id" : "Task.output.value[x]",
        "path" : "Task.output.value[x]",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      }
    ]
  }
}

```
