# SubstanceDefinition for publication - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SubstanceDefinition for publication**

## Resource Profile: SubstanceDefinition for publication 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:SubstanceDefinitionPublished |

 
This profile specified how the SubstanceDefinition is published by the WHO-UMC IDMP FHIR Service 

**Usages:**

* Examples for this Profile: [SubstanceDefinition/GSID23G92UMX93H45](SubstanceDefinition-GSID23G92UMX93H45.md), [SubstanceDefinition/GSID85RFP2XGF3X29](SubstanceDefinition-GSID85RFP2XGF3X29.md) and [SubstanceDefinition/GSID9XBS2KCF3K1Z1](SubstanceDefinition-GSID9XBS2KCF3K1Z1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/SubstanceDefinition-pub)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SubstanceDefinition-pub.csv), [Excel](StructureDefinition-SubstanceDefinition-pub.xlsx), [Schematron](StructureDefinition-SubstanceDefinition-pub.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SubstanceDefinition-pub",
  "url" : "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub",
  "version" : "0.1.0",
  "name" : "SubstanceDefinitionPublished",
  "title" : "SubstanceDefinition for publication",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specified how the SubstanceDefinition is published by the WHO-UMC IDMP FHIR Service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp-substance",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11238",
      "name" : "IDMP Mapping (Substance)"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "SubstanceDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/SubstanceDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "SubstanceDefinition",
        "path" : "SubstanceDefinition"
      },
      {
        "id" : "SubstanceDefinition.id",
        "path" : "SubstanceDefinition.id",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.text",
        "path" : "SubstanceDefinition.text",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.identifier",
        "path" : "SubstanceDefinition.identifier",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceDefinition.identifier.system",
        "path" : "SubstanceDefinition.identifier.system",
        "patternUri" : "http://who-umc.org/idmp/gsid"
      },
      {
        "id" : "SubstanceDefinition.version",
        "path" : "SubstanceDefinition.version",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.status",
        "path" : "SubstanceDefinition.status",
        "short" : "draft|active|retired",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.classification",
        "path" : "SubstanceDefinition.classification",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.domain",
        "path" : "SubstanceDefinition.domain",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.grade",
        "path" : "SubstanceDefinition.grade",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.description",
        "path" : "SubstanceDefinition.description",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.note",
        "path" : "SubstanceDefinition.note",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.manufacturer",
        "path" : "SubstanceDefinition.manufacturer",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.supplier",
        "path" : "SubstanceDefinition.supplier",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.moiety",
        "path" : "SubstanceDefinition.moiety",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.property",
        "path" : "SubstanceDefinition.property",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.molecularWeight",
        "path" : "SubstanceDefinition.molecularWeight",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "SubstanceDefinition.structure.representation",
        "path" : "SubstanceDefinition.structure.representation",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceDefinition.structure.representation.format.coding",
        "path" : "SubstanceDefinition.structure.representation.format.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceDefinition.structure.representation.format.coding.system",
        "path" : "SubstanceDefinition.structure.representation.format.coding.system",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.structure.representation.format.coding.code",
        "path" : "SubstanceDefinition.structure.representation.format.coding.code",
        "min" : 1,
        "patternCode" : "SMILES"
      },
      {
        "id" : "SubstanceDefinition.code.code.coding",
        "path" : "SubstanceDefinition.code.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "ordered" : false,
          "rules" : "closed"
        },
        "definition" : "Alternatives codes used for identifying this substance (UNII,CAS,EU-SRS)",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.code.code.coding.system",
        "path" : "SubstanceDefinition.code.code.coding.system",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.code.code.coding.code",
        "path" : "SubstanceDefinition.code.code.coding.code",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.code.code.coding:unii",
        "path" : "SubstanceDefinition.code.code.coding",
        "sliceName" : "unii",
        "short" : "UNII",
        "definition" : "FDA Unique identifer for subtances: UNII",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceDefinition.code.code.coding:unii.system",
        "path" : "SubstanceDefinition.code.code.coding.system",
        "patternUri" : "https://open.fda.gov/data/unii"
      },
      {
        "id" : "SubstanceDefinition.code.code.coding:cas",
        "path" : "SubstanceDefinition.code.code.coding",
        "sliceName" : "cas",
        "short" : "CAS",
        "definition" : "CAS subtances code",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceDefinition.code.code.coding:cas.system",
        "path" : "SubstanceDefinition.code.code.coding.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/CAS"
      },
      {
        "id" : "SubstanceDefinition.code.code.coding:eusrs",
        "path" : "SubstanceDefinition.code.code.coding",
        "sliceName" : "eusrs",
        "short" : "EU-SRS",
        "definition" : "European SRS",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceDefinition.code.code.coding:eusrs.system",
        "path" : "SubstanceDefinition.code.code.coding.system",
        "patternUri" : "http://example.org/eu-srs"
      },
      {
        "id" : "SubstanceDefinition.name",
        "path" : "SubstanceDefinition.name",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.name.status",
        "path" : "SubstanceDefinition.name.status",
        "short" : "name status"
      },
      {
        "id" : "SubstanceDefinition.name.preferred",
        "path" : "SubstanceDefinition.name.preferred",
        "min" : 1
      },
      {
        "id" : "SubstanceDefinition.name.language",
        "path" : "SubstanceDefinition.name.language",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "SubstanceDefinition.name.official",
        "path" : "SubstanceDefinition.name.official",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceDefinition.relationship",
        "path" : "SubstanceDefinition.relationship",
        "max" : "1"
      },
      {
        "id" : "SubstanceDefinition.sourceMaterial",
        "path" : "SubstanceDefinition.sourceMaterial",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      }
    ]
  }
}

```
