# Regulated Authorization - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Regulated Authorization**

## Resource Profile: Regulated Authorization 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/RegulatedAuthorization-who-php | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:RegulatedAuthorizationWhoPhpRequest |

 
RegulatedAuthorization is a resource covering the authorization of a type of regulated product, treatment, facility or activity 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/RegulatedAuthorization-who-php)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RegulatedAuthorization-who-php.csv), [Excel](StructureDefinition-RegulatedAuthorization-who-php.xlsx), [Schematron](StructureDefinition-RegulatedAuthorization-who-php.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RegulatedAuthorization-who-php",
  "url" : "http://who-umc.org/idmp/StructureDefinition/RegulatedAuthorization-who-php",
  "version" : "0.1.0",
  "name" : "RegulatedAuthorizationWhoPhpRequest",
  "title" : "Regulated Authorization",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "RegulatedAuthorization is a resource covering the authorization of a type of regulated product, treatment, facility or activity",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RegulatedAuthorization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RegulatedAuthorization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RegulatedAuthorization",
        "path" : "RegulatedAuthorization"
      },
      {
        "id" : "RegulatedAuthorization.subject",
        "path" : "RegulatedAuthorization.subject",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req"
            ]
          }
        ]
      },
      {
        "id" : "RegulatedAuthorization.holder",
        "path" : "RegulatedAuthorization.holder",
        "min" : 1
      }
    ]
  }
}

```
