# MedicinalProductDefinition for PhPID request - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicinalProductDefinition for PhPID request**

## Resource Profile: MedicinalProductDefinition for PhPID request 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:MedicinalProductDefinitionWhoPhPRequest |

 
This profile specified how the MedicinalProductDefinition is used in request (for a new PhPID) (as contained resource) by the WHO-UMC IDMP FHIR Service 

**Usages:**

* Refer to this Profile: [Ingredient (WHO PhP)](StructureDefinition-Ingredient-who-php.md), [Regulated Authorization](StructureDefinition-RegulatedAuthorization-who-php.md), [Task PhPID request status](StructureDefinition-Task-who-php-phpid-status.md) and [Task PhPID request](StructureDefinition-Task-who-php-phpid.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/MedicinalProductDefinition-who-php-req)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicinalProductDefinition-who-php-req.csv), [Excel](StructureDefinition-MedicinalProductDefinition-who-php-req.xlsx), [Schematron](StructureDefinition-MedicinalProductDefinition-who-php-req.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicinalProductDefinition-who-php-req",
  "url" : "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req",
  "version" : "0.1.0",
  "name" : "MedicinalProductDefinitionWhoPhPRequest",
  "title" : "MedicinalProductDefinition for PhPID request",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specified how the MedicinalProductDefinition is used in request (for a new PhPID) (as contained resource) by the WHO-UMC IDMP FHIR Service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicinalProductDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicinalProductDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicinalProductDefinition",
        "path" : "MedicinalProductDefinition",
        "constraint" : [
          {
            "key" : "name-type-required-multiple",
            "severity" : "error",
            "human" : "If name length >1, require name.type",
            "expression" : "name.count()=1 or name.type.exists()",
            "source" : "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req"
          }
        ]
      },
      {
        "id" : "MedicinalProductDefinition.id",
        "path" : "MedicinalProductDefinition.id",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.contained",
        "path" : "MedicinalProductDefinition.contained",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.identifier",
        "path" : "MedicinalProductDefinition.identifier",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.identifier.system",
        "path" : "MedicinalProductDefinition.identifier.system",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/mpid-system"
        }
      },
      {
        "id" : "MedicinalProductDefinition.identifier.value",
        "path" : "MedicinalProductDefinition.identifier.value",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.type",
        "path" : "MedicinalProductDefinition.type",
        "short" : "Regulatory type, e.g. Investigational or Authorized."
      },
      {
        "id" : "MedicinalProductDefinition.domain",
        "path" : "MedicinalProductDefinition.domain",
        "short" : "If this medicine applies to human or veterinary uses.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicinal-product-domain"
        }
      },
      {
        "id" : "MedicinalProductDefinition.status",
        "path" : "MedicinalProductDefinition.status",
        "short" : "The status within the lifecycle of this product record."
      },
      {
        "id" : "MedicinalProductDefinition.statusDate",
        "path" : "MedicinalProductDefinition.statusDate",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.description",
        "path" : "MedicinalProductDefinition.description",
        "short" : "General description of the medicinal product referred by the ePI"
      },
      {
        "id" : "MedicinalProductDefinition.combinedPharmaceuticalDoseForm",
        "path" : "MedicinalProductDefinition.combinedPharmaceuticalDoseForm",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/pharmaceuticalForm"
        }
      },
      {
        "id" : "MedicinalProductDefinition.route",
        "path" : "MedicinalProductDefinition.route",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/routeOfAdministration"
        }
      },
      {
        "id" : "MedicinalProductDefinition.indication",
        "path" : "MedicinalProductDefinition.indication",
        "short" : "Narrative text of the authorized indication(s) for this product."
      },
      {
        "id" : "MedicinalProductDefinition.legalStatusOfSupply",
        "path" : "MedicinalProductDefinition.legalStatusOfSupply",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.additionalMonitoringIndicator",
        "path" : "MedicinalProductDefinition.additionalMonitoringIndicator",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.specialMeasures",
        "path" : "MedicinalProductDefinition.specialMeasures",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.pediatricUseIndicator",
        "path" : "MedicinalProductDefinition.pediatricUseIndicator",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.classification",
        "path" : "MedicinalProductDefinition.classification",
        "short" : "Allows the product to be classified by various systems (e.g. ATC)",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/atcClassification"
        }
      },
      {
        "id" : "MedicinalProductDefinition.marketingStatus",
        "path" : "MedicinalProductDefinition.marketingStatus",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.packagedMedicinalProduct",
        "path" : "MedicinalProductDefinition.packagedMedicinalProduct",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "MedicinalProductDefinition.attachedDocument",
        "path" : "MedicinalProductDefinition.attachedDocument",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.attachedDocument.display",
        "path" : "MedicinalProductDefinition.attachedDocument.display",
        "short" : "The document that describes the product in detail",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.contact",
        "path" : "MedicinalProductDefinition.contact",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile",
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.productName",
        "path" : "MedicinalProductDefinition.name.productName",
        "short" : "The full product name."
      },
      {
        "id" : "MedicinalProductDefinition.name.type",
        "path" : "MedicinalProductDefinition.name.type",
        "short" : "Type of product name, such as rINN, BAN, Proprietary, Non-Proprietary."
      },
      {
        "id" : "MedicinalProductDefinition.name.part.part",
        "path" : "MedicinalProductDefinition.name.part.part",
        "short" : "A fragment of a product name."
      },
      {
        "id" : "MedicinalProductDefinition.name.part.type",
        "path" : "MedicinalProductDefinition.name.part.type",
        "short" : "Type for this part of the name (e.g. strength part)"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage",
        "path" : "MedicinalProductDefinition.name.usage",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country",
        "path" : "MedicinalProductDefinition.name.usage.country",
        "short" : "Country where this name applies"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country.coding",
        "path" : "MedicinalProductDefinition.name.usage.country.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country.coding.system",
        "path" : "MedicinalProductDefinition.name.usage.country.coding.system",
        "patternUri" : "urn:iso:std:iso:3166"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.country.coding.code",
        "path" : "MedicinalProductDefinition.name.usage.country.coding.code",
        "min" : 1
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.jurisdiction",
        "path" : "MedicinalProductDefinition.name.usage.jurisdiction",
        "short" : "Jurisdiction where this name applies"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.jurisdiction.coding",
        "path" : "MedicinalProductDefinition.name.usage.jurisdiction.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.jurisdiction.coding.code",
        "path" : "MedicinalProductDefinition.name.usage.jurisdiction.coding.code",
        "min" : 1,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/jurisdiction"
        }
      },
      {
        "id" : "MedicinalProductDefinition.name.usage.language",
        "path" : "MedicinalProductDefinition.name.usage.language",
        "short" : "Language for this name"
      }
    ]
  }
}

```
