# Ingredient (WHO PhP) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ingredient (WHO PhP)**

## Resource Profile: Ingredient (WHO PhP) 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:IngredientWhoPhP |

 
This profile specified how the Ingredient is used in a PhPID request (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service 

**Usages:**

* Refer to this Profile: [Task PhPID request status](StructureDefinition-Task-who-php-phpid-status.md) and [Task PhPID request](StructureDefinition-Task-who-php-phpid.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/Ingredient-who-php)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Ingredient-who-php.csv), [Excel](StructureDefinition-Ingredient-who-php.xlsx), [Schematron](StructureDefinition-Ingredient-who-php.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Ingredient-who-php",
  "url" : "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php",
  "version" : "0.1.0",
  "name" : "IngredientWhoPhP",
  "title" : "Ingredient (WHO PhP)",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specified how the Ingredient is used in a PhPID request (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Ingredient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Ingredient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Ingredient",
        "path" : "Ingredient",
        "constraint" : [
          {
            "key" : "presentation-required",
            "severity" : "error",
            "human" : "Either presentationRatio or presentationQuantity or textPresentation MUST be populated",
            "expression" : "substance.strength.presentation.ofType(Ratio).exists() or substance.strength.presentation.ofType(Quantity).exists() or substance.strength.textPresentation.exists()",
            "source" : "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php"
          }
        ]
      },
      {
        "id" : "Ingredient.id",
        "path" : "Ingredient.id",
        "min" : 1
      },
      {
        "id" : "Ingredient.status",
        "path" : "Ingredient.status",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.for",
        "path" : "Ingredient.for",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-req"
            ]
          }
        ]
      },
      {
        "id" : "Ingredient.role",
        "path" : "Ingredient.role",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ingredient-role"
        }
      },
      {
        "id" : "Ingredient.allergenicIndicator",
        "path" : "Ingredient.allergenicIndicator",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.manufacturer",
        "path" : "Ingredient.manufacturer",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.substance.code.concept.coding",
        "path" : "Ingredient.substance.code.concept.coding",
        "max" : "1"
      },
      {
        "id" : "Ingredient.substance.code.concept.coding.system",
        "path" : "Ingredient.substance.code.concept.coding.system",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.code.concept.coding.code",
        "path" : "Ingredient.substance.code.concept.coding.code",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.code.concept.text",
        "path" : "Ingredient.substance.code.concept.text",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength",
        "path" : "Ingredient.substance.strength",
        "short" : "The quantity of substance, per presentation, or per volume or mass, and type of quantity.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]",
        "path" : "Ingredient.substance.strength.presentation[x]",
        "type" : [
          {
            "code" : "Ratio"
          },
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Ingredient.substance.strength.textPresentation",
        "path" : "Ingredient.substance.strength.textPresentation",
        "short" : "Should only be used if the strength cannot be coded."
      },
      {
        "id" : "Ingredient.substance.strength.textConcentration",
        "path" : "Ingredient.substance.strength.textConcentration",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      }
    ]
  }
}

```
