# Ingredient (WHO PhP publish) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ingredient (WHO PhP publish)**

## Resource Profile: Ingredient (WHO PhP publish) 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php-publish | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:IngredientWhoPhPPublish |

 
This profile specified how the Ingredient is used in PhPID publishing (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service 

**Usages:**

* Use this Profile: [AdministrableProductDefinition (WHO PhP)](StructureDefinition-AdministrableProductDefinition-who-php.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/idmp.who-umc.org.fhir|current/StructureDefinition/Ingredient-who-php-publish)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Ingredient-who-php-publish.csv), [Excel](StructureDefinition-Ingredient-who-php-publish.xlsx), [Schematron](StructureDefinition-Ingredient-who-php-publish.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Ingredient-who-php-publish",
  "url" : "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php-publish",
  "version" : "0.1.0",
  "name" : "IngredientWhoPhPPublish",
  "title" : "Ingredient (WHO PhP publish)",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "This profile specified how the Ingredient is used in PhPID publishing (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Ingredient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Ingredient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Ingredient.id",
        "path" : "Ingredient.id",
        "min" : 1
      },
      {
        "id" : "Ingredient.status",
        "path" : "Ingredient.status",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.for",
        "path" : "Ingredient.for",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
            ]
          }
        ]
      },
      {
        "id" : "Ingredient.role",
        "path" : "Ingredient.role",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ingredient-role"
        }
      },
      {
        "id" : "Ingredient.allergenicIndicator",
        "path" : "Ingredient.allergenicIndicator",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.manufacturer",
        "path" : "Ingredient.manufacturer",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.substance.code.concept.coding",
        "path" : "Ingredient.substance.code.concept.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Ingredient.substance.code.concept.coding.system",
        "path" : "Ingredient.substance.code.concept.coding.system",
        "min" : 1,
        "patternUri" : "http://who-umc.org/idmp/gsid"
      },
      {
        "id" : "Ingredient.substance.code.concept.coding.code",
        "path" : "Ingredient.substance.code.concept.coding.code",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.code.concept.text",
        "path" : "Ingredient.substance.code.concept.text",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength",
        "path" : "Ingredient.substance.strength",
        "short" : "The quantity of substance, per presentation, or per volume or mass, and type of quantity.",
        "max" : "1"
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]",
        "path" : "Ingredient.substance.strength.presentation[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio",
        "path" : "Ingredient.substance.strength.presentation[x]",
        "sliceName" : "presentationRatio",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio.numerator",
        "path" : "Ingredient.substance.strength.presentation[x].numerator",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio.numerator.value",
        "path" : "Ingredient.substance.strength.presentation[x].numerator.value",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio.numerator.unit",
        "path" : "Ingredient.substance.strength.presentation[x].numerator.unit",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/strengthUnit"
        }
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio.denominator",
        "path" : "Ingredient.substance.strength.presentation[x].denominator",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio.denominator.value",
        "path" : "Ingredient.substance.strength.presentation[x].denominator.value",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationRatio.denominator.unit",
        "path" : "Ingredient.substance.strength.presentation[x].denominator.unit",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/strengthUnit"
        }
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationQuantity",
        "path" : "Ingredient.substance.strength.presentation[x]",
        "sliceName" : "presentationQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationQuantity.value",
        "path" : "Ingredient.substance.strength.presentation[x].value",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength.presentation[x]:presentationQuantity.unit",
        "path" : "Ingredient.substance.strength.presentation[x].unit",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://who-umc.org/idmp/ValueSet/strengthUnit"
        }
      },
      {
        "id" : "Ingredient.substance.strength.textConcentration",
        "path" : "Ingredient.substance.strength.textConcentration",
        "short" : "Not used in this profile",
        "definition" : "Not used in this profile"
      },
      {
        "id" : "Ingredient.substance.strength.referenceStrength",
        "path" : "Ingredient.substance.strength.referenceStrength",
        "max" : "1"
      },
      {
        "id" : "Ingredient.substance.strength.referenceStrength.substance",
        "path" : "Ingredient.substance.strength.referenceStrength.substance",
        "short" : "Relevant reference substance."
      },
      {
        "id" : "Ingredient.substance.strength.referenceStrength.substance.concept.coding",
        "path" : "Ingredient.substance.strength.referenceStrength.substance.concept.coding",
        "max" : "1"
      },
      {
        "id" : "Ingredient.substance.strength.referenceStrength.substance.concept.coding.system",
        "path" : "Ingredient.substance.strength.referenceStrength.substance.concept.coding.system",
        "min" : 1,
        "patternUri" : "http://who-umc.org/idmp/gsid"
      },
      {
        "id" : "Ingredient.substance.strength.referenceStrength.substance.concept.coding.code",
        "path" : "Ingredient.substance.strength.referenceStrength.substance.concept.coding.code",
        "min" : 1
      },
      {
        "id" : "Ingredient.substance.strength.referenceStrength.strength[x]",
        "path" : "Ingredient.substance.strength.referenceStrength.strength[x]",
        "short" : "Strength of the reference substance."
      }
    ]
  }
}

```
