# MedicinalProductDefinition (Auro methotrexate) - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicinalProductDefinition (Auro methotrexate)**

## Example MedicinalProductDefinition: MedicinalProductDefinition (Auro methotrexate)

# Medicinal Product (Medicinal Product Definition)

| | |
| :--- | :--- |
| Id | 1A0661AE2A40 |
| Name | Auro methotrexate |
| Mah | Auro Pharma Inc |
| Jurisdiction | Canada |

## ATC

| | |
| :--- | :--- |
| G02CX | Other gynecologicals |
| L01BA | Folic acid analogues |
| L04AX | Other immunosuppressants |

## Codes

| | | |
| :--- | :--- | :--- |
| http://who-umc.org/idmp/CodeSystem/drugcode | 00113802216 |  |

## PhPIDs

| | |
| :--- | :--- |
| 4 | 91B3CA582581F57E4092F13AAF476215 |



## Resource Content

```json
{
  "resourceType" : "MedicinalProductDefinition",
  "id" : "1A0661AE2A40",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2018-02-24T08:23:55.3332666+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-pub"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Organization",
      "id" : "auropharmainc",
      "name" : "Auro Pharma Inc"
    },
    {
      "resourceType" : "RegulatedAuthorization",
      "id" : "regauth",
      "subject" : [
        {
          "reference" : "#"
        }
      ],
      "holder" : {
        "reference" : "#auropharmainc"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://gupri-idmp.who-umc.org/data/record",
      "value" : "1A0661AE2A40"
    },
    {
      "system" : "https://health-products.canada.ca/dpd-bdpp",
      "value" : "02182750"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-type",
        "code" : "MedicinalProduct"
      }
    ]
  },
  "domain" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/medicinal-product-domain",
        "code" : "Human"
      }
    ],
    "text" : "Human use"
  },
  "status" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/publication-status",
        "code" : "active"
      }
    ],
    "text" : "Active"
  },
  "combinedPharmaceuticalDoseForm" : {
    "text" : "TABLETS"
  },
  "classification" : [
    {
      "coding" : [
        {
          "system" : "http://who-umc.org/idmp/level4-phpid",
          "code" : "91B3CA582581F57E4092F13AAF476215"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "G02CX"
        }
      ],
      "text" : "Other gynecologicals"
    },
    {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "L01BA"
        }
      ],
      "text" : "Folic acid analogues"
    },
    {
      "coding" : [
        {
          "system" : "http://www.whocc.no/atc",
          "code" : "L04AX"
        }
      ],
      "text" : "Other immunosuppressants"
    }
  ],
  "code" : [
    {
      "system" : "http://who-umc.org/idmp/CodeSystem/drugcode",
      "code" : "00113802216"
    }
  ],
  "name" : [
    {
      "productName" : "Auro methotrexate",
      "usage" : [
        {
          "country" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "CAN"
              }
            ]
          },
          "jurisdiction" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "CAN"
              }
            ]
          },
          "language" : {
            "coding" : [
              {
                "system" : "urn:ietf:bcp:47",
                "code" : "en"
              }
            ]
          }
        }
      ]
    }
  ]
}

```
