# WHODrug DrugCode - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **WHODrug DrugCode**

## CodeSystem: WHODrug DrugCode 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/CodeSystem/drugcode | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:DrugCode |
| **Copyright/Legal**: Uppsala Monitoring Centre | |

 
Description of WHODrug DrugCode code system (B-format) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

**Properties**

**This code system defines the following properties for its concepts**

**Concepts**

This case-insensitive code system `http://who-umc.org/idmp/CodeSystem/drugcode` provides some codes **that are example only**:



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "drugcode",
  "url" : "http://who-umc.org/idmp/CodeSystem/drugcode",
  "version" : "0.1.0",
  "name" : "DrugCode",
  "title" : "WHODrug DrugCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "Description of WHODrug DrugCode code system (B-format)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "copyright" : "Uppsala Monitoring Centre",
  "caseSensitive" : false,
  "compositional" : false,
  "content" : "example",
  "property" : [
    {
      "code" : "DrugCode",
      "description" : "The drug code, carrying information of base, salt variant and trade name",
      "type" : "string"
    },
    {
      "code" : "Name",
      "description" : "The name of the product",
      "type" : "string"
    },
    {
      "code" : "Generic",
      "description" : "Indicates if this is a generic product",
      "type" : "boolean"
    },
    {
      "code" : "Base",
      "description" : "Indicates if this is a base product = true or salt = false",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "00020001004",
      "display" : "Alvedon",
      "property" : [
        {
          "code" : "Name",
          "valueString" : "Alvedon"
        },
        {
          "code" : "DrugCode",
          "valueString" : "00020001004"
        },
        {
          "code" : "Generic",
          "valueBoolean" : false
        },
        {
          "code" : "Base",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "00002701006",
      "display" : "Magnecyl",
      "property" : [
        {
          "code" : "Name",
          "valueString" : "Magnecyl"
        },
        {
          "code" : "DrugCode",
          "valueString" : "00002701006"
        },
        {
          "code" : "Generic",
          "valueBoolean" : false
        },
        {
          "code" : "Base",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "00113802085",
      "display" : "Methotrexaat sandoz",
      "property" : [
        {
          "code" : "Name",
          "valueString" : "Methotrexaat sandoz"
        },
        {
          "code" : "DrugCode",
          "valueString" : "00113802085"
        },
        {
          "code" : "Generic",
          "valueBoolean" : false
        },
        {
          "code" : "Base",
          "valueBoolean" : false
        }
      ]
    }
  ]
}

```
