# AdministrableProductDefinition level 2 - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdministrableProductDefinition level 2**

## Example AdministrableProductDefinition: AdministrableProductDefinition level 2

# Pharmaceutical Product (Administrable Product Definition)

| | |
| :--- | :--- |
| Id | 8195D4AF1287CCE3442C2F308F61DBBC |
| Level | 2 |

## Ingredients

| | | |
| :--- | :--- | :--- |
| GSID9XBS2KCF3K1Z1 | METHOTREXATE SODIUM | 2,74 mg |

## Form

|
|

## Parent PhPIDs

| | |
| :--- | :--- |
| 1 | 93FE88350C2E8868F7E8BD220C4E0010 |



## Resource Content

```json
{
  "resourceType" : "AdministrableProductDefinition",
  "id" : "8195D4AF1287CCE3442C2F308F61DBBC",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2023-12-25T08:23:53.9351567+00:00",
    "source" : "https://poc-idmp.who-umc.org/fhir",
    "profile" : [
      "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Ingredient",
      "id" : "0e70ec76-156e-43f7-be5a-50b9474d9a42",
      "meta" : {
        "source" : "https://poc-idmp.who-umc.org/fhir",
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Ingredient-who-php-publish"
        ]
      },
      "status" : "active",
      "for" : [
        {
          "reference" : "#"
        }
      ],
      "role" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/ingredient-role",
            "code" : "100000072072"
          }
        ],
        "text" : "Active"
      },
      "substance" : {
        "code" : {
          "reference" : {
            "reference" : "SubstanceDefinition/GSID9XBS2KCF3K1Z1",
            "identifier" : {
              "system" : "https://gupri-idmp.who-umc.org/data/substance",
              "value" : "GSID9XBS2KCF3K1Z1"
            },
            "display" : "METHOTREXATE SODIUM"
          }
        },
        "strength" : [
          {
            "presentationQuantity" : {
              "value" : 2.74,
              "unit" : "mg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg"
            },
            "textPresentation" : "2,74 mg",
            "referenceStrength" : [
              {
                "substance" : {
                  "reference" : {
                    "reference" : "SubstanceDefinition/GSID9XBS2KCF3K1Z1",
                    "identifier" : {
                      "system" : "https://gupri-idmp.who-umc.org/data/substance",
                      "value" : "GSID9XBS2KCF3K1Z1"
                    },
                    "display" : "METHOTREXATE SODIUM"
                  }
                },
                "strengthQuantity" : {
                  "value" : 2.50,
                  "unit" : "mg",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "mg"
                }
              }
            ]
          }
        ]
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://who-umc.org/idmp/StructureDefinition/parent-phpid",
      "valueReference" : {
        "reference" : "AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
                "code" : "PhPIDLevel1"
              }
            ]
          },
          "system" : "https://gupri-idmp.who-umc.org/data/php",
          "value" : "93FE88350C2E8868F7E8BD220C4E0010"
        }
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://who-umc.org/idmp/CodeSystem/php-level",
            "code" : "PhPIDLevel2"
          }
        ]
      },
      "system" : "https://gupri-idmp.who-umc.org/data/php",
      "value" : "8195D4AF1287CCE3442C2F308F61DBBC"
    }
  ],
  "status" : "active",
  "routeOfAdministration" : [
    {
      "code" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    }
  ]
}

```
