# Versioning - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **Versioning**

## Versioning

> This part of the specification is only on a DRAFT level, it is not yet decided how the versioning of the API and the profiles will be handled. The versioning of the content will however follow the FHIR principles.

### Introduction

The UMC IDMP API has support for versions in several different ways, all of them important depending on the context:

* Versioning of data (content)
* Versioning of the API itself
* Versioning of FHIR
* Versioning of Profiles

#### Versioning of content

The content of the resources will be versioned using the built in versioning mechanism within the meta data section of each resource.

#### Versioning of API

****Note I:**** **The reason that the below described versioning mechanism has been selected is that we do not want the URL to change since that might affect clients using the entire URL to reference resources.**

The current version of the WHO-UMC IDMP Service API as well as the FHIR version is shown in the Capability Statement. When requesting the Capability Statement using /metadata the current (active) version of the API is returned in the software.version attribute.

The API supports a limited number of historical versions as outlined in the table in the end of this section. Generally the latest version of the API is the default, if a previous version of the API is to be used that version must be specified in every request using the following header:

> GET [base]/[resource]/[id]x-api-version: x.y;

****Note II:**** **only two digits of the API version number can be used in this way**

If an API version that is not supported is requested a `406 - Not Acceptable` response will be returned with a detailed message.

It is foreseen that the API will be continously upgraded. To prepare for this, clients are encouraged to use the above method to verify that the version they need is still supported.

Only API versions with breaking changes will be handled as described above. Minor versions that are backwards compatible with the previous version, affecting only the third didgit 'z' in (x.y.z), will not be possible to specify.

If an API version that is no longer the "latest" version is requested a `20x` response will be returned with a `Warning` header as follows.

> Warning: 299 IDMPService "Support for the requested FHIR version will be retired YYYYMMDD"

****Note III:**** **Implementers of the API should have a process to take action on such messages and be prepared to migrate to the latest version well in time before the expiration date.**

****Note IV:**** **xxx in the above examples should be replaced with xml or json.**

#### FHIR versioning

There is no specific version handling in regards to FHIR versions. FHIR versions will follow the API versioning so if a new FHIR version is released which the client can **not yet** support the client needs to continue using the old API version until ready to migrate to the new version.

#### Versioning of resources

Versioning of resources through profiles follow the versioning of the API.

### Table of supported API and FHIR versions, example

| | | | |
| :--- | :--- | :--- | :--- |
| 2.2 | 5.0 | Current | N/A |
| 2.1 | 5.0 | Active | 2025-12-31 |
| 2.0 | 5.0 | Retired | 2024-12-31 |
| 1.1 | 4.0 | Active | 2025-12-31 |
| 1.0 | 4.0 | Retired | 2024-12-31 |

