# Terminologies - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **Terminologies**

## Terminologies

### WHO-UMC IDMP Terminologies

This page lists all the terminology assets that have been specificed for the purpose of the WHO-UMC IDMP project

### Code Systems

[EDQM dose form attributes](CodeSystem-edqmDoseFormAttributes.md)

This system lists the dose form attributes from the EDQM CodeSystem. This is a temporary solution while waiting for the EDQM dose form attributes to be available in the official HL7 EDQM CodeSystem.

[Additional jurisdictional areas compolementing the ISO 3166 country codes](CodeSystem-jurisdiction.md)

Additional jurisdictional areas compolementing the ISO 3166 country codes.

[Pdf Characteristics](CodeSystem-pdfCharacteristics.md)

This system lists the available pharmaceutical dose form characteristics

[PhPId level](CodeSystem-php-level.md)

This system lists PhPID types: level and stratum

[Task input type](CodeSystem-task-input-type.md)

This system lists the available input types for a task

[Task output type](CodeSystem-task-output-type.md)

This system lists the available output types for a task

[Task request code](CodeSystem-task-request-code.md)

This code system lists Task request codes in the IDMP PhPID service.

[WHODrug DrugCode](CodeSystem-drugcode.md)

Description of WHODrug DrugCode code system (B-format)

[Strength units applicable in the IDMP PhPID service](CodeSystem-strengthUnit.md)

This code system lists applicable strength units in the IDMP PhPID service. They are a sub set of the unum units with some additions.

### Value Sets

[WHO ATC](ValueSet-atcClassification.md)

World Health Organization Anatomical Therapeutic Chemical (ATC) classification system

[Jurisdiction Value Set](ValueSet-jurisdiction.md)

Jurisdiction Value Set

[MPID system](ValueSet-mpid-system.md)

Medicinal Product identification systems

[Identifier Type Value Set](ValueSet-phpid-type.md)

Identifier Type Value Set

[Request Status Value Set](ValueSet-requestStatus.md)

Request Status Value Set

[Route Of Administration](ValueSet-routeOfAdministration.md)

Route Of Administration

[Strength Unit Value Set](ValueSet-strengthUnit.md)

Strength Unit Value Set

[Channel Type Value Set](ValueSet-channelType.md)

Channel type Value Set accepted by the IDMP Service

[GSID request input type value set](ValueSet-gsid-task-input-type.md)

GSID request input type value set

[GSID request output type value set](ValueSet-gsid-task-output-type.md)

GSID request output type value set

[PhPID request input type value set](ValueSet-phpid-task-input-type.md)

PhPID request input type value set

[PhPID request output type value set](ValueSet-phpid-task-output-type.md)

PhPID request output type value set

[EDQM Pharmaceutical Form](ValueSet-pharmaceuticalForm.md)

EDQM Pharmaceutical Forms

[EDQM PDF characteristics: Administration Method](ValueSet-edqm-AME.md)

EDQM Pharmaceutical dose forms characteristics: Administration Method

[EDQM PDF characteristics: Basic Dose Form](ValueSet-edqm-BDF.md)

EDQM Pharmaceutical dose forms characteristics: Basic Dose Form

[EDQM PDF characteristics: Intended Site](ValueSet-edqm-ISI.md)

EDQM Pharmaceutical dose forms characteristics: Intended Site

[EDQM PDF characteristics: Release Characteristics](ValueSet-edqm-RCA.md)

EDQM Pharmaceutical dose forms characteristics: Release Characteristics

### Concept Maps

-------

