# Operating model - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **Operating model**

## Operating model

### Operating model

Following is a picture of the operating model for requesting and publishing PhPIDs.

![](OperatingModel.png) 

#### Operations

1. A requester in need for a global PhPID sends a request containing the product information.
1. The sent in request is validated against GIDWG Business rules by pharmacists in the maintenance organisation.
1. The validated and harmonized dose form attributes, substance and strength information is used as input string in the generation of PhPIDs.
1. The requester receives the PhPIDs, levels 1-4, for their medicinal product.
1. The generated PhPIDs are stored in the PhPID repository.

#### Corresponding FHIR operations

1. A FHIR[Task](StructureDefinition-Task-who-php-phpid.md)is used to request a new global PhPID where necessary information to complete the request is embedded in the contains section of the Task. See[PhPID request model](phpIdRequest.md)for details.
1. While validating the request the status of the Task indicates to progress.
1. The Task is**ready**and transits to**completed**via**in-progress**.
1. The new (or already existing) Global PhPID is published in the output section of the Task and is thereafter available as an[AdministrableProductDefinition](StructureDefinition-AdministrableProductDefinition-who-php.md)resource.
1. Searching for an existing PhPID can be done using standard search functionality. Search and filter parameters is available in the Capability Statement.

