# UMC IDMP Request and Publish API - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **UMC IDMP Request and Publish API**

## UMC IDMP Request and Publish API

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ImplementationGuide/idmp.who-umc.org.fhir | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:UmcIDMPManagement |

### Scope

The scope of this Implementation Guide is to document the UMC IDMP API FHIR service, by describing the context in which the API can be used as well as the technical overview for using the API.

### Introduction

This Implementation Guide has a target audience of system integrators to the UMC IDMP API. The API is based on the HL7 FHIR standard and this guide describes supported FHIR resources.

The Implementation Guide describes how FHIR standard is used to exchange data for ISO IDMP standards for global PhPIDs and GSIDs. For information about ISO IDMP, see the [Background](background.md) section in this guide.

The main resources maintained by the service are the Pharmaceutical Product IDs, PhPIDs, (manifested through the AdministrableProductDefinition resource) and the Global Substance IDs, GSIDs, (manifested through the SubstanceDefinition resource). However, the MedicinalProductDefinition resource is also vital since it serves as input for PhPID generation. The Implementation Guide describes how new global PhPIDs are requested using asynchronous FHIR requests, and how they are delivered through FHIR.

#### Access to the UMC IDMP FHIR server

##### Production

The production FHIR server can be reached at [https://idmp.who-umc.org/fhir](https://idmp.who-umc.org/fhir). To get access to the production server, please contact asa.parnaste [at] who-umc.org.

##### Preview

The preview FHIR server can be reached at [https://preview-idmp.who-umc.org/fhir](https://preview-idmp.who-umc.org/fhir). To get access to the preview server, please contact asa.parnaste [at] who-umc.org.

##### Proof of Concept

The PoC FHIR server can be reached at [https://api.umcterminologies.org/idmp](https://api.umcterminologies/idmp). A tutorial with examples is found at [https://api.umcterminologies.org/](https://api.umcterminologies.org/)

### Dependencies



### Cross Version Analysis

### Global Profiles

*There are no Global profiles defined*

### IP statements

This publication includes IP covered under the following statements.

* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* SNOMED Clinical Terms&reg; (SNOMED CT&reg;): [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md) and [VsRouteOfAdministration](ValueSet-routeOfAdministration.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Organization type](http://terminology.hl7.org/7.0.0/CodeSystem-organization-type.html): [Task/task-completed-phpid](Task-task-completed-phpid.md) and [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md)
* [SubscriptionChannel Type Codes](http://terminology.hl7.org/7.0.0/CodeSystem-subscription-channel-type.html): [Demo end point](Subscription-template-generated-by-server-subscription-rest-hook.md), [SubscriptionIdmpEvent](StructureDefinition-Subscription-IdmpEvent.md) and [channelType](ValueSet-channelType.md)


* Unless otherwise indicated, reproduction of material posted on Council of Europe websites, and reproduction of photographs for which the Council of Europe holds copyright – see legal notice \“photo credits\” – is authorised for private use and for informational and educational uses relating to the Council of Europe’s work. This authorisation is subject to the condition that the source be indicated and no charge made for reproduction. Persons wishing to make some other use than those specified above, including commercial use, of information and text posted on these sites are asked to apply for prior written authorisation to the Council of Europe, Directorate of Communication.

* [EDQM Standard Terms](http://tx.fhir.org/r5/ValueSet/edqm): [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md) and [pharmaceuticalForm](ValueSet-pharmaceuticalForm.md)


* Uppsala Monitoring Centre

* [WHODrug DrugCode](CodeSystem-drugcode.md): [MedicinalProductDefinition/1266520E021](MedicinalProductDefinition-1266520E021.md) and [MedicinalProductDefinition/1A0661AE2A40](MedicinalProductDefinition-1A0661AE2A40.md)
* [EDQM dose form attributes](CodeSystem-edqmDoseFormAttributes.md): [AME](StructureDefinition-administration-method.md), [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md)...Show 8 more,[AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md),[BDF](StructureDefinition-basic-dose-form.md),[ISI](StructureDefinition-intended-site.md),[RCA](StructureDefinition-release-characteristics.md),[edqm-AME](ValueSet-edqm-AME.md),[edqm-BDF](ValueSet-edqm-BDF.md),[edqm-ISI](ValueSet-edqm-ISI.md)and[edqm-RCA](ValueSet-edqm-RCA.md)
* [Additional jurisdictional areas compolementing the ISO 3166 country codes](CodeSystem-jurisdiction.md): [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md), [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md) and [VsJurisdiction](ValueSet-jurisdiction.md)
* [PhPId level](CodeSystem-php-level.md): [AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md), [AdministrableProductDefinition/8195D4AF1287CCE3442C2F308F61DBBC](AdministrableProductDefinition-8195D4AF1287CCE3442C2F308F61DBBC.md)...Show 5 more,[AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md),[AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010](AdministrableProductDefinition-93FE88350C2E8868F7E8BD220C4E0010.md),[AdministrableProductDefinitionWhoPhP](StructureDefinition-AdministrableProductDefinition-who-php.md),[Task/task-completed-phpid](Task-task-completed-phpid.md)and[VsPhpIdLevels](ValueSet-phpid-type.md)
* [Strength units applicable in the IDMP PhPID service](CodeSystem-strengthUnit.md): [IngredientWhoPhPPublish](StructureDefinition-Ingredient-who-php-publish.md), [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md) and [VsStrengthUnit](ValueSet-strengthUnit.md)
* [Task input type](CodeSystem-task-input-type.md): [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md)...Show 4 more,[TaskGeneratePhPID](StructureDefinition-Task-who-php-phpid.md),[TaskGeneratePhPIDStatus](StructureDefinition-Task-who-php-phpid-status.md),[VsGSIDTaskInputTypes](ValueSet-gsid-task-input-type.md)and[VsPhPIDTaskInputTypes](ValueSet-phpid-task-input-type.md)
* [Task output type](CodeSystem-task-output-type.md): [Task/task-completed-phpid](Task-task-completed-phpid.md), [TaskGeneratePhPIDStatus](StructureDefinition-Task-who-php-phpid-status.md), [VsGSIDTaskOutputTypes](ValueSet-gsid-task-output-type.md) and [VsPhPIDTaskOutputTypes](ValueSet-phpid-task-output-type.md)
* [Task request code](CodeSystem-task-request-code.md): [Task/task-completed-phpid](Task-task-completed-phpid.md), [Task/template-generated-by-server-phpid-req](Task-template-generated-by-server-phpid-req.md), [TaskGeneratePhPID](StructureDefinition-Task-who-php-phpid.md) and [TaskGeneratePhPIDStatus](StructureDefinition-Task-who-php-phpid-status.md)


* WHO Collaborating Centre for Drug Statistics Methodology, Oslo, Norway. Use of all or parts of the material requires reference to the WHO Collaborating Centre for Drug Statistics Methodology. Copying and distribution for commercial purposes is not allowed. Changing or manipulating the material is not allowed.

* [ATC classification system](http://tx.fhir.org/r5/ValueSet/atc): [MedicinalProductDefinition/1266520E021](MedicinalProductDefinition-1266520E021.md), [MedicinalProductDefinition/1A0661AE2A40](MedicinalProductDefinition-1A0661AE2A40.md), [MedicinalProductDefinitionWhoPhP](StructureDefinition-MedicinalProductDefinition-who-php-pub.md), [MedicinalProductDefinitionWhoPhPRequest](StructureDefinition-MedicinalProductDefinition-who-php-req.md) and [VsAtcClassification](ValueSet-atcClassification.md)


### Authors and Contributors

| | | | |
| :--- | :--- | :--- | :--- |
| Author | Magnus Wallberg | Uppsala Monitoring Centre | magnus.wallberg [at] who-umc.org |
| Author | Giorgio Cangioli | HL7 Europe | giorgio.cangioli [at] gmail.com |
| Author | Åsa Pärnaste | Uppsala Monitoring Centre | asa.parnaste [at] who-umc.org |
| Author | João Almeida | HL7 Europe | joaofilipe90 [at] gmail.com |
| Author | Mikael Nilsson | Uppsala Monitoring Centre | mikael.nilsson [at] who-umc.org |



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "idmp.who-umc.org.fhir",
  "url" : "http://who-umc.org/idmp/ImplementationGuide/idmp.who-umc.org.fhir",
  "version" : "0.1.0",
  "name" : "UmcIDMPManagement",
  "title" : "UMC IDMP Request and Publish API",
  "status" : "active",
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "The UMC IDMP API supports management and publishing of PhPIDs and GSIDs as part of the ISO IDMP standard",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "packageId" : "idmp.who-umc.org.fhir",
  "license" : "CC0-1.0",
  "fhirVersion" : ["5.0.0"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r5",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r5",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r5#0.8.0"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/jurisdiction"
        },
        "name" : "Additional jurisdictional areas compolementing the ISO 3166 country codes",
        "description" : "Additional jurisdictional areas compolementing the ISO 3166 country codes.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubscriptionTopic"
          }
        ],
        "reference" : {
          "reference" : "SubscriptionTopic/admProdDef"
        },
        "name" : "Administrable Product Definition Event",
        "description" : "An APD has triggered an event",
        "isExample" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AdministrableProductDefinition-who-php"
        },
        "name" : "AdministrableProductDefinition (WHO PhP)",
        "description" : "This profile specified how the AdministrableProductDefinition is published by the WHO-UMC IDMP Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AdministrableProductDefinition"
          }
        ],
        "reference" : {
          "reference" : "AdministrableProductDefinition/93FE88350C2E8868F7E8BD220C4E0010"
        },
        "name" : "AdministrableProductDefinition level 1",
        "description" : "AdministrableProductDefinition on level 1. Linked from a level 4, 3 and 2 APD.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AdministrableProductDefinition"
          }
        ],
        "reference" : {
          "reference" : "AdministrableProductDefinition/8195D4AF1287CCE3442C2F308F61DBBC"
        },
        "name" : "AdministrableProductDefinition level 2",
        "description" : "AdministrableProductDefinition on level 2. Linked from a level 4 APD.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AdministrableProductDefinition"
          }
        ],
        "reference" : {
          "reference" : "AdministrableProductDefinition/6C4563BB76BE7967594979196EC91CD8"
        },
        "name" : "AdministrableProductDefinition level 3",
        "description" : "AdministrableProductDefinition on level 3. Linked from a level 4 APD.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AdministrableProductDefinition"
          }
        ],
        "reference" : {
          "reference" : "AdministrableProductDefinition/91B3CA582581F57E4092F13AAF476215"
        },
        "name" : "AdministrableProductDefinition level 4",
        "description" : "Example of AdministrableProductDefinition returned by the server on level 4.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/AdministrableProductDefinition-who-php"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/UMC-IDMP-API"
        },
        "name" : "API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs",
        "description" : "The UMC IDMP API supports management and publishing of PhPIDs and publishing of GSIDs as part of the ISO IDMP standard. It also supports publishing of some other related resources as described in the Implementation Guide",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/channelType"
        },
        "name" : "Channel Type Value Set",
        "description" : "Channel type Value Set accepted by the IDMP Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/edqmDoseFormAttributes"
        },
        "name" : "EDQM dose form attributes",
        "description" : "This system lists the dose form attributes from the EDQM CodeSystem. This is a temporary solution while waiting for the EDQM dose form attributes to be available in the official HL7 EDQM CodeSystem.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/edqm-AME"
        },
        "name" : "EDQM PDF characteristics: Administration Method",
        "description" : "EDQM Pharmaceutical dose forms characteristics: Administration Method",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/edqm-BDF"
        },
        "name" : "EDQM PDF characteristics: Basic Dose Form",
        "description" : "EDQM Pharmaceutical dose forms characteristics: Basic Dose Form",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/edqm-ISI"
        },
        "name" : "EDQM PDF characteristics: Intended Site",
        "description" : "EDQM Pharmaceutical dose forms characteristics: Intended Site",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/edqm-RCA"
        },
        "name" : "EDQM PDF characteristics: Release Characteristics",
        "description" : "EDQM Pharmaceutical dose forms characteristics: Release Characteristics",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/pharmaceuticalForm"
        },
        "name" : "EDQM Pharmaceutical Form",
        "description" : "EDQM Pharmaceutical Forms",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/task-completed-phpid"
        },
        "name" : "Example of a completed Task",
        "description" : "An example of a completed task with output.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Task-who-php-phpid-status"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/gsid-task-input-type"
        },
        "name" : "GSID request input type value set",
        "description" : "GSID request input type value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/gsid-task-output-type"
        },
        "name" : "GSID request output type value set",
        "description" : "GSID request output type value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/phpid-type"
        },
        "name" : "Identifier Type Value Set",
        "description" : "Identifier Type Value Set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Ingredient-who-php-publish"
        },
        "name" : "Ingredient (WHO PhP publish)",
        "description" : "This profile specified how the Ingredient is used in PhPID publishing (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Ingredient-who-php"
        },
        "name" : "Ingredient (WHO PhP)",
        "description" : "This profile specified how the Ingredient is used in a PhPID request (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/jurisdiction"
        },
        "name" : "Jurisdiction Value Set",
        "description" : "Jurisdiction Value Set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MarketingAuthorizationHolder-who-php"
        },
        "name" : "Marketing Authorization Holder",
        "description" : "Marketing Authorization Holder of medicinal product",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicinalProductDefinition"
          }
        ],
        "reference" : {
          "reference" : "MedicinalProductDefinition/1A0661AE2A40"
        },
        "name" : "MedicinalProductDefinition (Auro methotrexate)",
        "description" : "Example of a WHODrug product published as a MedicinalProductDefinition.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-pub"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicinalProductDefinition"
          }
        ],
        "reference" : {
          "reference" : "MedicinalProductDefinition/1266520E021"
        },
        "name" : "MedicinalProductDefinition (Methotrexaat sandoz)",
        "description" : "Example of a WHODrug product published as a MedicinalProductDefinition.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/MedicinalProductDefinition-who-php-pub"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicinalProductDefinition-who-php-req"
        },
        "name" : "MedicinalProductDefinition for PhPID request",
        "description" : "This profile specified how the MedicinalProductDefinition is used in request (for a new PhPID) (as contained resource) by the WHO-UMC IDMP FHIR Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicinalProductDefinition-who-php-pub"
        },
        "name" : "MedicinalProductDefinition for publication",
        "description" : "This profile specifies how the MedicinalProductDefinition is published by the WHO-UMC IDMP FHIR Service representing the WHODrug dictionary",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mpid-system"
        },
        "name" : "MPID system",
        "description" : "Medicinal Product identification systems",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AuthorizedOrg-who-php"
        },
        "name" : "Organization authorized to use the WHO-UMC IDMP service",
        "description" : "Organization making the request, not necessarily the same organization as the one sending the task",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/parent-phpid"
        },
        "name" : "Parent PhP",
        "description" : "This extension applies to the ADP resource and is used to refer the parent ADPs representing the upper level PhP.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/parent-php"
        },
        "name" : "Parent PhPID",
        "description" : "Search PhPIDs based on 'parent' PhPIDs",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/pdfCharacteristics"
        },
        "name" : "Pdf Characteristics",
        "description" : "This system lists the available pharmaceutical dose form characteristics",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/administration-method"
        },
        "name" : "Pharmaceutical dose form - AdministrationMethod",
        "description" : "This extension is use to display the AdministrationMethod for an AdministrableProductDefinition",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/basic-dose-form"
        },
        "name" : "Pharmaceutical dose form - BasicDoseForm",
        "description" : "This extension is use to display the BasicDoseForm for an AdministrableProductDefinition",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/intended-site"
        },
        "name" : "Pharmaceutical dose form - IntendedSite",
        "description" : "This extension is use to display the IntendedSite for an AdministrableProductDefinition",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/release-characteristics"
        },
        "name" : "Pharmaceutical dose form - ReleaseCharacteristics",
        "description" : "This extension is use to display the ReleaseCharacteristics for an AdministrableProductDefinition",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/php-level"
        },
        "name" : "PhPId level",
        "description" : "This system lists PhPID types: level and stratum",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/phpid-task-input-type"
        },
        "name" : "PhPID request input type value set",
        "description" : "PhPID request input type value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/phpid-task-output-type"
        },
        "name" : "PhPID request output type value set",
        "description" : "PhPID request output type value set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RegulatedAuthorization-who-php"
        },
        "name" : "Regulated Authorization",
        "description" : "RegulatedAuthorization is a resource covering the authorization of a type of regulated product, treatment, facility or activity",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/requestStatus"
        },
        "name" : "Request Status Value Set",
        "description" : "Request Status Value Set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/routeOfAdministration"
        },
        "name" : "Route Of Administration",
        "description" : "Route Of Administration",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/strengthUnit"
        },
        "name" : "Strength Unit Value Set",
        "description" : "Strength Unit Value Set",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/strengthUnit"
        },
        "name" : "Strength units applicable in the IDMP PhPID service",
        "description" : "This code system lists applicable strength units in the IDMP PhPID service. They are a sub set of the unum units with some additions.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Subscription-IdmpEvent"
        },
        "name" : "Subscription for event notifications",
        "description" : "Subscription for event notifications",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/template-generated-by-server-subscription-rest-hook"
        },
        "name" : "Subscription for MedicinalProductDefinition changes",
        "description" : "A template for how to create a subscription for a MPD change with a rest hook",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Subscription-IdmpEvent"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/template-generated-by-server-subscription-email"
        },
        "name" : "Subscription for PhPID changes",
        "description" : "A template for how to create a subscription for a PhPID change with an email hook",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Subscription-IdmpEvent"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubstanceDefinition"
          }
        ],
        "reference" : {
          "reference" : "SubstanceDefinition/GSID9XBS2KCF3K1Z1"
        },
        "name" : "Substance (METHOTREXATE SODIUM)",
        "description" : "An example of a GSID (salt variant) publisehed as a SubstanceDefinition",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubstanceDefinition"
          }
        ],
        "reference" : {
          "reference" : "SubstanceDefinition/GSID23G92UMX93H45"
        },
        "name" : "Substance (METHOTREXATE)",
        "description" : "An example of a GSID publisehed as a SubstanceDefinition",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubstanceDefinition"
          }
        ],
        "reference" : {
          "reference" : "SubstanceDefinition/GSID85RFP2XGF3X29"
        },
        "name" : "Substance (OMEPRAZOLE)",
        "description" : "An example of a GSID publisehed as a SubstanceDefinition",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/SubstanceDefinition-pub"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubstanceDefinition-pub"
        },
        "name" : "SubstanceDefinition for publication",
        "description" : "This profile specified how the SubstanceDefinition is published by the WHO-UMC IDMP FHIR Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/task-input-type"
        },
        "name" : "Task input type",
        "description" : "This system lists the available input types for a task",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/task-output-type"
        },
        "name" : "Task output type",
        "description" : "This system lists the available output types for a task",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Task-who-php-phpid"
        },
        "name" : "Task PhPID request",
        "description" : "This profile specified how to use the Task resource to request (via POST) the generation of a PhPID by using the WHO-UMC IDMP FHIR Service",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Task-who-php-phpid-status"
        },
        "name" : "Task PhPID request status",
        "description" : "This profile specified how to use the Task resource to request status of a previously sent request",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/task-request-code"
        },
        "name" : "Task request code",
        "description" : "This code system lists Task request codes in the IDMP PhPID service.",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/template-generated-by-server-phpid-req"
        },
        "name" : "Task to request a new PhPID",
        "description" : "A template for how a Task that is used to request a new PhPID (AdministrableProductDefinition) can be structured.",
        "isExample" : true,
        "profile" : [
          "http://who-umc.org/idmp/StructureDefinition/Task-who-php-phpid"
        ]
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/atcClassification"
        },
        "name" : "WHO ATC",
        "description" : "World Health Organization Anatomical Therapeutic Chemical (ATC) classification system",
        "isExample" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/drugcode"
        },
        "name" : "WHODrug DrugCode",
        "description" : "Description of WHODrug DrugCode code system (B-format)",
        "isExample" : false
      }
    ],
    "page" : {
      "sourceUrl" : "toc.html",
      "name" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "sourceUrl" : "index.html",
          "name" : "index.html",
          "title" : "UMC IDMP Request and Publish API",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "background.html",
          "name" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "operatingModel.html",
          "name" : "operatingModel.html",
          "title" : "Operating model",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "phpIdRequest.html",
          "name" : "phpIdRequest.html",
          "title" : "PhPID (AdministrableProductDefinition) request",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "publishing.html",
          "name" : "publishing.html",
          "title" : "Publishing",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "authentication.html",
          "name" : "authentication.html",
          "title" : "Authentication",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "subscription.html",
          "name" : "subscription.html",
          "title" : "Change management",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "versioning.html",
          "name" : "versioning.html",
          "title" : "Versioning",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "profiles.html",
          "name" : "profiles.html",
          "title" : "Profiles",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "terminologies.html",
          "name" : "terminologies.html",
          "title" : "Terminologies",
          "generation" : "markdown"
        },
        {
          "sourceUrl" : "downloads.html",
          "name" : "downloads.html",
          "title" : "Useful downloads",
          "generation" : "html"
        },
        {
          "sourceUrl" : "changes.html",
          "name" : "changes.html",
          "title" : "IG change history",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "copyrightyear"
        },
        "value" : "2025+"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "releaselabel"
        },
        "value" : "CI Build"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "show-inherited-invariants"
        },
        "value" : "false"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "produce-jekyll-data"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "https://who-umc.org/idmp/StructureDefinition/parent-phpid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "special-url"
        },
        "value" : "https://who-umc.org/idmp/StructureDefinition/pdfCharacteristics"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "autoload-resources"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/capabilities"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/examples"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/extensions"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/models"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/operations"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/profiles"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/vocabulary"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/maps"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/testing"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "input/history"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-resource"
        },
        "value" : "fsh-generated/resources"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "template/config"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-pages"
        },
        "value" : "input/images"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "template/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-liquid"
        },
        "value" : "input/liquid"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-qa"
        },
        "value" : "temp/qa"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-temp"
        },
        "value" : "temp/pages"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-output"
        },
        "value" : "output"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/guide-parameter-code",
          "code" : "path-tx-cache"
        },
        "value" : "input-cache/txcache"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-suppressed-warnings"
        },
        "value" : "input/ignoreWarnings.txt"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "path-history"
        },
        "value" : "http://who-umc.org/idmp/history.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-html"
        },
        "value" : "template-page.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "template-md"
        },
        "value" : "template-page-md.html"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-contact"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-context"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-copyright"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-jurisdiction"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-license"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-publisher"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-version"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "apply-wg"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "active-tables"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "fmm-definition"
        },
        "value" : "http://hl7.org/fhir/versions.html#maturity"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "propagate-status"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "excludelogbinaryformat"
        },
        "value" : "true"
      },
      {
        "code" : {
          "system" : "http://hl7.org/fhir/tools/CodeSystem/ig-parameters",
          "code" : "tabbed-snapshots"
        },
        "value" : "true"
      }
    ]
  }
}

```
