# Background - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **Background**

## Background

### Definitions

* IDMP - Identification of Medicinal Products
* PhPID - Pharmaceutical Product Identifier
* GSID - Global Substance Identifier
* EDQM - European Directorate for the Quality of Medicines & HealthCare Standard Terms for pharmaceutical dose forms
* GIDWG - Global IDMP Working Group

### ISO IDMP

IDMP – Identification of Medicinal Products – is a set of five standards developed by the International Organization for Standardization (ISO) to create a universal framework of structured, coded data that uniquely identify and describe all key aspects of medicinal products. The Identification of Medicinal Products (IDMP) standards aim to increase clarity and efficiency in communications about medicines and provide greater certainty to patients no matter where they are.

#### PhPID and GSID

The UMC IDMP API supports two parts of the ISO IDMP standard, the Pharmaceutical Product Identifier (PhPID) and the Global Substance Identifier (GSID):

* Pharmaceutical Product Identification – ISO 11616
* Substance Identification – ISO 11238

![](Overview.png) 

The PhPID is based on substance-, strength- and dose form information of the pharmaceutical product. This information, once validated and harmonized through a set of business rules developed by the GIDWG, is used as input to the generation of the PhPID. PhPIDs of four different levels are generated, as follows:

* PhPID Level 1 - Substance(s) Term
* PhPID Level 2 - Substance(s) Term(s) + Strength
* PhPID Level 3 - Substance(s) Term(s) + Administrable Dose Form
* PhPID Level 4 - Substance(s) Term(s) + Strength + Administrable Dose Form

