# Artifacts Summary - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [API to allow for Requests of PhPIDs and Publishing of PhPIDs, GSIDs and MPDs](CapabilityStatement-UMC-IDMP-API.md) | The UMC IDMP API supports management and publishing of PhPIDs and publishing of GSIDs as part of the ISO IDMP standard. It also supports publishing of some other related resources as described in the Implementation Guide |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [Parent PhPID](SearchParameter-parent-php.md) | Search PhPIDs based on 'parent' PhPIDs |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AdministrableProductDefinition (WHO PhP)](StructureDefinition-AdministrableProductDefinition-who-php.md) | This profile specified how the AdministrableProductDefinition is published by the WHO-UMC IDMP Service |
| [Ingredient (WHO PhP publish)](StructureDefinition-Ingredient-who-php-publish.md) | This profile specified how the Ingredient is used in PhPID publishing (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service |
| [Ingredient (WHO PhP)](StructureDefinition-Ingredient-who-php.md) | This profile specified how the Ingredient is used in a PhPID request (as contained resource in a MedicinalProductDefinition) by the WHO-UMC PhP HL7 FHIR Service |
| [Marketing Authorization Holder](StructureDefinition-MarketingAuthorizationHolder-who-php.md) | Marketing Authorization Holder of medicinal product |
| [MedicinalProductDefinition for PhPID request](StructureDefinition-MedicinalProductDefinition-who-php-req.md) | This profile specified how the MedicinalProductDefinition is used in request (for a new PhPID) (as contained resource) by the WHO-UMC IDMP FHIR Service |
| [MedicinalProductDefinition for publication](StructureDefinition-MedicinalProductDefinition-who-php-pub.md) | This profile specifies how the MedicinalProductDefinition is published by the WHO-UMC IDMP FHIR Service representing the WHODrug dictionary |
| [Organization authorized to use the WHO-UMC IDMP service](StructureDefinition-AuthorizedOrg-who-php.md) | Organization making the request, not necessarily the same organization as the one sending the task |
| [Regulated Authorization](StructureDefinition-RegulatedAuthorization-who-php.md) | RegulatedAuthorization is a resource covering the authorization of a type of regulated product, treatment, facility or activity |
| [Subscription for event notifications](StructureDefinition-Subscription-IdmpEvent.md) | Subscription for event notifications |
| [SubstanceDefinition for publication](StructureDefinition-SubstanceDefinition-pub.md) | This profile specified how the SubstanceDefinition is published by the WHO-UMC IDMP FHIR Service |
| [Task PhPID request](StructureDefinition-Task-who-php-phpid.md) | This profile specified how to use the Task resource to request (via POST) the generation of a PhPID by using the WHO-UMC IDMP FHIR Service |
| [Task PhPID request status](StructureDefinition-Task-who-php-phpid-status.md) | This profile specified how to use the Task resource to request status of a previously sent request |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Parent PhP](StructureDefinition-parent-phpid.md) | This extension applies to the ADP resource and is used to refer the parent ADPs representing the upper level PhP. |
| [Pharmaceutical dose form - AdministrationMethod](StructureDefinition-administration-method.md) | This extension is use to display the AdministrationMethod for an AdministrableProductDefinition |
| [Pharmaceutical dose form - BasicDoseForm](StructureDefinition-basic-dose-form.md) | This extension is use to display the BasicDoseForm for an AdministrableProductDefinition |
| [Pharmaceutical dose form - IntendedSite](StructureDefinition-intended-site.md) | This extension is use to display the IntendedSite for an AdministrableProductDefinition |
| [Pharmaceutical dose form - ReleaseCharacteristics](StructureDefinition-release-characteristics.md) | This extension is use to display the ReleaseCharacteristics for an AdministrableProductDefinition |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Channel Type Value Set](ValueSet-channelType.md) | Channel type Value Set accepted by the IDMP Service |
| [EDQM PDF characteristics: Administration Method](ValueSet-edqm-AME.md) | EDQM Pharmaceutical dose forms characteristics: Administration Method |
| [EDQM PDF characteristics: Basic Dose Form](ValueSet-edqm-BDF.md) | EDQM Pharmaceutical dose forms characteristics: Basic Dose Form |
| [EDQM PDF characteristics: Intended Site](ValueSet-edqm-ISI.md) | EDQM Pharmaceutical dose forms characteristics: Intended Site |
| [EDQM PDF characteristics: Release Characteristics](ValueSet-edqm-RCA.md) | EDQM Pharmaceutical dose forms characteristics: Release Characteristics |
| [EDQM Pharmaceutical Form](ValueSet-pharmaceuticalForm.md) | EDQM Pharmaceutical Forms |
| [GSID request input type value set](ValueSet-gsid-task-input-type.md) | GSID request input type value set |
| [GSID request output type value set](ValueSet-gsid-task-output-type.md) | GSID request output type value set |
| [Identifier Type Value Set](ValueSet-phpid-type.md) | Identifier Type Value Set |
| [Jurisdiction Value Set](ValueSet-jurisdiction.md) | Jurisdiction Value Set |
| [MPID system](ValueSet-mpid-system.md) | Medicinal Product identification systems |
| [PhPID request input type value set](ValueSet-phpid-task-input-type.md) | PhPID request input type value set |
| [PhPID request output type value set](ValueSet-phpid-task-output-type.md) | PhPID request output type value set |
| [Request Status Value Set](ValueSet-requestStatus.md) | Request Status Value Set |
| [Route Of Administration](ValueSet-routeOfAdministration.md) | Route Of Administration |
| [Strength Unit Value Set](ValueSet-strengthUnit.md) | Strength Unit Value Set |
| [WHO ATC](ValueSet-atcClassification.md) | World Health Organization Anatomical Therapeutic Chemical (ATC) classification system |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Additional jurisdictional areas compolementing the ISO 3166 country codes](CodeSystem-jurisdiction.md) | Additional jurisdictional areas compolementing the ISO 3166 country codes. |
| [EDQM dose form attributes](CodeSystem-edqmDoseFormAttributes.md) | This system lists the dose form attributes from the EDQM CodeSystem. This is a temporary solution while waiting for the EDQM dose form attributes to be available in the official HL7 EDQM CodeSystem. |
| [Pdf Characteristics](CodeSystem-pdfCharacteristics.md) | This system lists the available pharmaceutical dose form characteristics |
| [PhPId level](CodeSystem-php-level.md) | This system lists PhPID types: level and stratum |
| [Strength units applicable in the IDMP PhPID service](CodeSystem-strengthUnit.md) | This code system lists applicable strength units in the IDMP PhPID service. They are a sub set of the unum units with some additions. |
| [Task input type](CodeSystem-task-input-type.md) | This system lists the available input types for a task |
| [Task output type](CodeSystem-task-output-type.md) | This system lists the available output types for a task |
| [Task request code](CodeSystem-task-request-code.md) | This code system lists Task request codes in the IDMP PhPID service. |
| [WHODrug DrugCode](CodeSystem-drugcode.md) | Description of WHODrug DrugCode code system (B-format) |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Administrable Product Definition Event](SubscriptionTopic-admProdDef.md) | An APD has triggered an event |
| [AdministrableProductDefinition level 1](AdministrableProductDefinition-93FE88350C2E8868F7E8BD220C4E0010.md) | AdministrableProductDefinition on level 1. Linked from a level 4, 3 and 2 APD. |
| [AdministrableProductDefinition level 2](AdministrableProductDefinition-8195D4AF1287CCE3442C2F308F61DBBC.md) | AdministrableProductDefinition on level 2. Linked from a level 4 APD. |
| [AdministrableProductDefinition level 3](AdministrableProductDefinition-6C4563BB76BE7967594979196EC91CD8.md) | AdministrableProductDefinition on level 3. Linked from a level 4 APD. |
| [AdministrableProductDefinition level 4](AdministrableProductDefinition-91B3CA582581F57E4092F13AAF476215.md) | Example of AdministrableProductDefinition returned by the server on level 4. |
| [Example of a completed Task](Task-task-completed-phpid.md) | An example of a completed task with output. |
| [MedicinalProductDefinition (Auro methotrexate)](MedicinalProductDefinition-1A0661AE2A40.md) | Example of a WHODrug product published as a MedicinalProductDefinition. |
| [MedicinalProductDefinition (Methotrexaat sandoz)](MedicinalProductDefinition-1266520E021.md) | Example of a WHODrug product published as a MedicinalProductDefinition. |
| [Subscription for MedicinalProductDefinition changes](Subscription-template-generated-by-server-subscription-rest-hook.md) | A template for how to create a subscription for a MPD change with a rest hook |
| [Subscription for PhPID changes](Subscription-template-generated-by-server-subscription-email.md) | A template for how to create a subscription for a PhPID change with an email hook |
| [Substance (METHOTREXATE SODIUM)](SubstanceDefinition-GSID9XBS2KCF3K1Z1.md) | An example of a GSID (salt variant) publisehed as a SubstanceDefinition |
| [Substance (METHOTREXATE)](SubstanceDefinition-GSID23G92UMX93H45.md) | An example of a GSID publisehed as a SubstanceDefinition |
| [Substance (OMEPRAZOLE)](SubstanceDefinition-GSID85RFP2XGF3X29.md) | An example of a GSID publisehed as a SubstanceDefinition |
| [Task to request a new PhPID](Task-template-generated-by-server-phpid-req.md) | A template for how a Task that is used to request a new PhPID (AdministrableProductDefinition) can be structured. |

