# Strength Unit Value Set - UMC IDMP Request and Publish API v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Strength Unit Value Set**

## ValueSet: Strength Unit Value Set 

| | |
| :--- | :--- |
| *Official URL*:http://who-umc.org/idmp/ValueSet/strengthUnit | *Version*:0.1.0 |
| Active as of 2025-11-19 | *Computable Name*:VsStrengthUnit |

 
Strength Unit Value Set 

 **References** 

* [Ingredient (WHO PhP publish)](StructureDefinition-Ingredient-who-php-publish.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in [`http://who-umc.org/idmp/CodeSystem/strengthUnit`](CodeSystem-strengthUnit.md)version 📦0.1.0
* Include all codes defined in [`http://unitsofmeasure.org`](http://unitsofmeasure.org)version Not Stated (use latest from terminology server)

 

### Expansion

Expansion from tx.fhir.org based on:

* codesystem UCUM version 2.2
* [codesystem Strength units applicable in the IDMP PhPID service v0.1.0 (CodeSystem)](CodeSystem-strengthUnit.md)

This value set cannot be fully expanded, but a selection (841 codes) of the whole set of codes is shown here.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "strengthUnit",
  "url" : "http://who-umc.org/idmp/ValueSet/strengthUnit",
  "version" : "0.1.0",
  "name" : "VsStrengthUnit",
  "title" : "Strength Unit Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-19T07:03:36+00:00",
  "publisher" : "Uppsala Monitoring Centre",
  "contact" : [
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    },
    {
      "name" : "Uppsala Monitoring Centre",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.who-umc.org"
        }
      ]
    }
  ],
  "description" : "Strength Unit Value Set",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://who-umc.org/idmp/CodeSystem/strengthUnit"
      },
      {
        "system" : "http://unitsofmeasure.org"
      }
    ]
  }
}

```
